% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{class}
\name{DAresult-class}
\alias{DAresult-class}
\title{Differential abundance analysis result}
\description{
An S4 class to represent ADAPT analysis results
}
\details{
The analysis result object contains the analysis name, reference taxa, DA taxa,
detailed analysis results as a dataframe and the input phyloseq object.
The analysis name contains the condition variable. The reference taxa \code{reference}
must be nonempty. DA taxa \code{signal} may be an empty string if no taxa are differentially abundant.
The \code{details} dataframe contains the taxa names, the prevalence of taxa, the estimated
log10 absolute abundance fold changes, the raw hypothesis test p-values and BH-adjusted p-values.
}
\section{Slots}{

\describe{
\item{\code{DAAname}}{The name of differential abundance analysis}

\item{\code{reference}}{A vector of taxa names corresponding to all the reference taxa}

\item{\code{signal}}{A vector of taxa names corresponding to all the DA taxa}

\item{\code{details}}{A dataframe with the analysis results for all taxa}

\item{\code{input}}{Input phyloseq object}
}}

