% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clr_glm-tpq.R
\name{aldex.glm}
\alias{aldex.glm}
\title{Calculate glm test statistics using a \code{model.matrix}}
\usage{
aldex.glm(clr, verbose = FALSE, fdr.method = "holm", ...)
}
\arguments{
\item{clr}{An \code{ALDEx2} object. The output of \code{aldex.clr}.}

\item{verbose}{A boolean. Toggles whether to print diagnostic information while
running. Useful for debugging errors on large datasets. Applies to
\code{effect = TRUE}.}

\item{fdr.method}{A string ("BH" or "holm") denoting which method to use to adjust p-values. Default is "holm"}

\item{...}{Arguments passed to \code{glm}.}
}
\value{
Returns a data.frame of the average
 coefficients and their p-values for each feature,
 with FDR appended as a \code{holm} column.
}
\description{
\code{aldex.glm} calculates the expected values for each coefficient of a
 glm model on the data returned by \code{aldex.clr}. This function
 requires the user to define a model with \code{model.matrix}.
}
\examples{
data(selex)
#subset for efficiency
selex <- selex[1201:1600,]
covariates <- data.frame("A" = sample(0:1, 14, replace = TRUE),
                         "B" = c(rep(0, 7), rep(1, 7)))
mm <- model.matrix(~ A + B, covariates)
x <- aldex.clr(selex, mm, mc.samples=4, denom="all")
glm.test <- aldex.glm(x)
glm.eff <- aldex.glm.effect(x)
aldex.glm.plot(glm.test, eff=glm.eff, contrast='B', type='MW', post.hoc='holm')

}
\references{
Please use the citation given by
 \code{citation(package="ALDEx2")}.
}
\seealso{
\code{\link{aldex}},
 \code{\link{aldex.clr}},
 \code{\link{aldex.ttest}},
 \code{\link{aldex.kw}},
 \code{\link{aldex.glm}},
 \code{\link{aldex.effect}},
 \code{\link{aldex.corr}},
 \code{\link{selex}}
}
\author{
Thom Quinn, Michelle Pistner
}
