% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{ca_3Dplot}
\alias{ca_3Dplot}
\alias{ca_3Dplot,cacomp-method}
\alias{ca_3Dplot,Seurat-method}
\alias{ca_3Dplot,SingleCellExperiment-method}
\title{Plot of the first 3D CA projection of the data.}
\usage{
ca_3Dplot(
  obj,
  xdim = 1,
  ydim = 2,
  zdim = 3,
  princ_coords = 1,
  row_labels = NULL,
  col_labels = NULL,
  ...
)

\S4method{ca_3Dplot}{cacomp}(
  obj,
  xdim = 1,
  ydim = 2,
  zdim = 3,
  princ_coords = 1,
  row_labels = NULL,
  col_labels = NULL,
  ...
)

\S4method{ca_3Dplot}{Seurat}(
  obj,
  xdim = 1,
  ydim = 2,
  zdim = 3,
  princ_coords = 1,
  row_labels = NULL,
  col_labels = NULL,
  ...,
  assay = SeuratObject::DefaultAssay(obj),
  slot = "counts"
)

\S4method{ca_3Dplot}{SingleCellExperiment}(
  obj,
  xdim = 1,
  ydim = 2,
  zdim = 3,
  princ_coords = 1,
  row_labels = NULL,
  col_labels = NULL,
  ...,
  assay = "counts"
)
}
\arguments{
\item{obj}{An object of class "cacomp", or alternatively an object of
class "Seurat" or "SingleCellExperiment" with a dim. reduction named "CA"
saved.}

\item{xdim}{Integer. The dimension for the x-axis. Default 1.}

\item{ydim}{Integer. The dimension for the y-axis. Default 2.}

\item{zdim}{Integer. The dimension for the z-axis. Default 3.}

\item{princ_coords}{Integer. If 1 then principal coordinates are used for
the rows, if 2 for the columns. Default 1 (rows).}

\item{row_labels}{Numeric vector. Indices for the rows for which a label
should be added (label should be stored in rownames). Default NULL.}

\item{col_labels}{Numeric vector. Indices for the columns for which
a label should be added (label should be stored in colnames).
Default NULL (no columns).}

\item{...}{Further arguments.}

\item{assay}{SingleCellExperiment assay to obtain counts from.}

\item{slot}{Seurat slot from assay to get count matrix from.}
}
\value{
Plot of class "plotly".
}
\description{
Plots the first 3 dimensions of the rows and columns in the same plot.
}
\details{
Depending on whether `princ_coords` is set to 1 or 2 either the principal
coordinates of either the rows (1) or the columns (2)
are chosen. For the other the standardized coordinates are plotted
(assymetric biplot).
Labels for rows and columns should be stored in the row- and column
names respectively.
}
\examples{
# Simulate counts
cnts <- mapply(function(x){rpois(n = 500, lambda = x)},
               x = sample(1:100, 50, replace = TRUE))
rownames(cnts) <- paste0("gene_", 1:nrow(cnts))
colnames(cnts) <- paste0("cell_", 1:ncol(cnts))

# Run correspondence analysis
ca <- cacomp(obj = cnts, princ_coords = 3)

ca_3Dplot(ca)
}
