% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{var_rows}
\alias{var_rows}
\title{Find most variable rows}
\usage{
var_rows(mat, residuals = "pearson", top = 5000, ...)
}
\arguments{
\item{mat}{A numeric matrix. For sequencing a count matrix,
gene expression values with genes in rows and samples/cells in columns.
Should contain row and column names.}

\item{residuals}{character string. Specifies which kind of residuals should
be calculated. Can be "pearson" (default), "freemantukey" or "NB" for
negative-binomial.}

\item{top}{Integer. Number of most variable rows to retain. Default 5000.}

\item{...}{Further arguments for `calc_residuals`.}
}
\value{
Returns a matrix, which consists of the top variable rows of mat.
}
\description{
Calculates the variance of the chi-square component matrix and selects the
rows with the highest variance, e.g. 5,000.
}
\examples{
set.seed(1234)

# Simulate counts
cnts <- mapply(function(x){rpois(n = 500, lambda = x)},
              x = sample(1:20, 50, replace = TRUE))
rownames(cnts) <- paste0("gene_", 1:nrow(cnts))
colnames(cnts) <- paste0("cell_", 1:ncol(cnts))

# Choose top 5000 most variable genes
cnts <- var_rows(mat = cnts, top = 5000)


}
