% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastASSET.R
\name{create_blocks}
\alias{create_blocks}
\title{Create blocks from correlation matrix}
\usage{
create_blocks(cormat, cor_thr = 0.2)
}
\arguments{
\item{cormat}{A named k by k correlation matrix of z-statistics with row and column names being the names of studies/traits.}

\item{cor_thr}{Threshold of correlation to divide the set of traits into blocks. Z-statistics with correlation less than \code{cor_thr} are treated as uncorrelated.}
}
\value{
A list of character vectors. Each element is a vector of study/trait names that fall into the same correlation block based on \code{cormat}. Studies from different blocks are treated as independent. Studies that are not in the list are treated as independent from other studies.
}
\description{
Partition the set of traits into blocks of correlated traits using hierarchical clustering.
}
\examples{
data("ex_fast_asset", package="ASSET")
block <- create_blocks(ldscintmat)
}
