% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot-methods.R
\docType{methods}
\name{ASEset-barplot}
\alias{ASEset-barplot}
\alias{barplot}
\alias{barplot,ASEset-method}
\title{barplot ASEset objects}
\usage{
barplot(height, ...)

\S4method{barplot}{ASEset}(
  height,
  type = "count",
  sampleColour.top = NULL,
  sampleColour.bot = NULL,
  legend = TRUE,
  pValue = TRUE,
  strand = "*",
  testValue = NULL,
  testValue2 = NULL,
  OrgDb = NULL,
  TxDb = NULL,
  annotationType = c("gene", "exon", "transcript"),
  main = NULL,
  ylim = NULL,
  yaxis = TRUE,
  xaxis = FALSE,
  ylab = TRUE,
  ylab.text = NULL,
  xlab.text = "samples",
  xlab = TRUE,
  legend.colnames = "",
  las.ylab = 1,
  las.xlab = 2,
  cex.main = 1,
  cex.pValue = 0.7,
  cex.ylab = 0.7,
  cex.xlab = 0.7,
  cex.legend = 0.6,
  add = FALSE,
  lowerLeftCorner = c(0, 0),
  size = c(1, 1),
  addHorizontalLine = 0.5,
  add.frame = TRUE,
  filter.pValue.fraction = 0.99,
  legend.fill.size = 1,
  legend.interspace = 1,
  verbose = FALSE,
  top.fraction.criteria = "maxcount",
  cex.annotation = 0.7,
  ypos.annotation = 0,
  annotation.interspace = 1,
  ...
)
}
\arguments{
\item{height}{An \code{ASEset} object}

\item{...}{for simpler generics when extending function}

\item{type}{'count' or 'fraction'}

\item{sampleColour.top}{User specified colours for top fraction}

\item{sampleColour.bot}{User specified colours for bottom fraction}

\item{legend}{Display legend}

\item{pValue}{Display p-value}

\item{strand}{four options, '+', '-', 'both' or '*'}

\item{testValue}{if set, a matrix or vector with user p-values}

\item{testValue2}{if set, a matrix or vector with user p-values}

\item{OrgDb}{an OrgDb object which provides annotation}

\item{TxDb}{a TxDb object which provides annotation}

\item{annotationType}{select one or more from
'gene','exon','transcript','cds'.}

\item{main}{text to use as main label}

\item{ylim}{set plot y-axis limit}

\item{yaxis}{wheter the y-axis is to be displayed or not}

\item{xaxis}{wheter the x-axis is to be displayed or not}

\item{ylab}{showing labels for the tic marks}

\item{ylab.text}{ylab text}

\item{xlab.text}{xlab text}

\item{xlab}{showing labels for the tic marks}

\item{legend.colnames}{gives colnames to the legend matrix}

\item{las.ylab}{orientation of ylab text}

\item{las.xlab}{orientation of xlab text}

\item{cex.main}{set main label size (max 2)}

\item{cex.pValue}{set pValue label size}

\item{cex.ylab}{set ylab label size}

\item{cex.xlab}{set xlab label size}

\item{cex.legend}{set legend label size}

\item{add}{\code{boolean} indicates if a new device should be started}

\item{lowerLeftCorner}{integer that is only useful when \code{add}=TRUE}

\item{size}{Used internally by locationplot. Rescales each small barplot
window}

\item{addHorizontalLine}{adds a horizontal line that marks the default
fraction of 0.5 - 0.5}

\item{add.frame}{\code{boolean} to give the new plot a frame or not}

\item{filter.pValue.fraction}{\code{numeric} between 0 and 1 that filter
away pValues where the main allele has this frequency.}

\item{legend.fill.size}{size of the fill/boxes in the legend (default:NULL)}

\item{legend.interspace}{set legend space between fills and text}

\item{verbose}{Makes function more talkative}

\item{top.fraction.criteria}{'maxcount', 'ref' or 'phase'}

\item{cex.annotation}{size of annotation text}

\item{ypos.annotation}{relative ypos for annotation text}

\item{annotation.interspace}{space between annotation text}
}
\description{
Generates barplots for ASEset objects. Two levels of plotting detail are
provided: a detailed barplot of read counts by allele useful for fewer
samples and SNPs, and a less detailed barplot of the fraction of imbalance,
useful for more samples and SNPs.
}
\details{
\code{filter.pValue.fraction} is intended to remove p-value annotation with
very large difference in frequency, which could just be a sequencing
mistake. This is to avoid p-values like 1e-235 or similar.

\code{sampleColour}User specified colours, either given as named colours
('red', 'blue', etc) or as hexadecimal code. Can be either length 1 for all
samples, or else of a length corresponding to the number of samples for
individual colouring.
}
\examples{

data(ASEset)
barplot(ASEset[1])

}
\seealso{
\itemize{ \item The \code{\link{ASEset}} class which the barplot
function can be called up on.  }
}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{barplot}
