% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{DetectedAI-plot}
\alias{DetectedAI-plot}
\alias{frequency_vs_threshold_variable_plot}
\alias{frequency_vs_threshold_variable_plot,DetectedAI-class}
\alias{frequency_vs_threshold_variable_plot,DetectedAI-method}
\alias{detectedAI_vs_threshold_variable_plot}
\alias{detectedAI_vs_threshold_variable_plot,DetectedAI-method}
\alias{reference_frequency_density_vs_threshold_variable_plot}
\alias{reference_frequency_density_vs_threshold_variable_plot,DetectedAI-method}
\alias{detectedAI_vs_threshold_variable_multigraph_plot}
\alias{detectedAI_vs_threshold_variable_multigraph_plot,DetectedAI-method}
\alias{frequency_vs_threshold_variable_multigraph_plot}
\alias{frequency_vs_threshold_variable_multigraph_plot,DetectedAI-method}
\alias{reference_frequency_density_vs_threshold_variable_multigraph_plot}
\alias{reference_frequency_density_vs_threshold_variable_multigraph_plot,DetectedAI-method}
\title{DetectedAI plot}
\usage{
frequency_vs_threshold_variable_plot(x, ...)

\S4method{frequency_vs_threshold_variable_plot}{DetectedAI}(
  x,
  var = "threshold.count.sample",
  hetOverlay = TRUE,
  smoothscatter = FALSE
)

detectedAI_vs_threshold_variable_plot(x, ...)

\S4method{detectedAI_vs_threshold_variable_plot}{DetectedAI}(
  x,
  var = "threshold.count.sample",
  summaryOverSamples = "sum",
  hetOverlay = TRUE,
  smoothscatter = FALSE
)

reference_frequency_density_vs_threshold_variable_plot(x, ...)

\S4method{reference_frequency_density_vs_threshold_variable_plot}{DetectedAI}(
  x,
  var = "threshold.count.sample"
)

detectedAI_vs_threshold_variable_multigraph_plot(x, ...)

\S4method{detectedAI_vs_threshold_variable_multigraph_plot}{DetectedAI}(x, ncol = 2, ...)

frequency_vs_threshold_variable_multigraph_plot(x, ...)

\S4method{frequency_vs_threshold_variable_multigraph_plot}{DetectedAI}(x, ncol = 2, ...)

reference_frequency_density_vs_threshold_variable_multigraph_plot(x, ...)

\S4method{reference_frequency_density_vs_threshold_variable_multigraph_plot}{DetectedAI}(
  x,
  ncol = 2,
  ...
)
}
\arguments{
\item{x}{detectedAI object}

\item{...}{pass on variables internally}

\item{var}{string, see details for available options}

\item{hetOverlay}{logical, if TRUE show nr of het SNPs used to calculate the reference allele frequency mean}

\item{smoothscatter}{boolean, smoothscatter over the means}

\item{summaryOverSamples}{'mean' or 'sum'}

\item{ncol}{nr of columns for multiplots}
}
\description{
plot functions for the DetectedAI-class
}
\details{
plot helper functions. The documentation will
be improved before next release.
}
\examples{

#some example code here
#generate example
data(ASEset)
a <- ASEset
dai <- detectAI(a, 
			threshold.count.sample=1:50,
			threshold.frequency=seq(0,0.5,by=0.01),
			threshold.delta.frequency=seq(0,0.5,by=0.01),
			threshold.pvalue=rev(seq(0.001,0.05, by=0.005))
)

frequency_vs_threshold_variable_plot(dai)
detectedAI_vs_threshold_variable_plot(dai)
detectedAI_vs_threshold_variable_multigraph_plot(dai)
frequency_vs_threshold_variable_multigraph_plot(dai)

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{list}
