% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom.test-methods.R
\docType{methods}
\name{binom.test}
\alias{binom.test}
\alias{binom.test,ASEset-method}
\title{binomial test}
\usage{
\S4method{binom.test}{ASEset}(x, n = "*")
}
\arguments{
\item{x}{\code{ASEset} object}

\item{n}{strand option}
}
\value{
\code{binom.test} returns a matrix
}
\description{
Performs a binomial test on an ASEset object.
}
\details{
the test can only be applied to one strand at the time.
}
\examples{

#load example data
data(ASEset)

#make a binomial test
binom.test(ASEset,'*')


}
\seealso{
\itemize{ \item The \code{\link{chisq.test}} which is another test
that can be applied on an \link{ASEset} object.  }
}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{binomial}
\keyword{test}
