% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_rDolphin_blood.R
\name{files_to_rDolphin}
\alias{files_to_rDolphin}
\title{Files to rDoplhin}
\usage{
files_to_rDolphin(nmr_dataset, biological_origin)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset} object}

\item{biological_origin}{String specify the type of sample (blood, urine, cell)}
}
\value{
a list containing:
\itemize{
\item \code{meta_rDolphin}: metadata in rDolphin format,
\item \code{NMR_spectra}: spectra matrix
\item \code{ROI}: ROI template
\item \code{Parameters}: parameters file
}
}
\description{
The rDolphin family functions are introduced to perform automatic targeted
metabolite profiling. Therefore, ensure that you interpolated from -0.1 ppm
in order to consider the TSP/DSS signal at 0.0 ppm. The function generates a
list with the files required by to_rDolphin function. Then, it is required
to save them with the \code{save_files_to_rDolphin}. to_rDolphin function will
read the generated "parameters.csv" file.
function.
}
\examples{
\dontrun{
# Set the directory in which rDolphin files will be saved
output_dir_10_rDolphin <- file.path(your_path, "10-rDolphin")
fs::dir_create(output_dir_10_rDolphin)

# Generate the files (for plasma/serum)
files_rDolphin <- files_to_rDolphin(nmr_dataset_0_10_ppm, blood)

# Save the files
save_files_to_rDolphin(files_rDolphin, output_dir_10_rDolphin)

# Build the rDolphin object. Do not forget to set the directory
setwd(output_dir_10_rDolphin)
rDolphin_object <- to_rDolphin("Parameters.csv")

# Visualize your spectra
rDolphin_plot(rDolphin_object)

# Run the main profiling function (it takes a while)
targeted_profiling <- Automatic_targeted_profiling(rDolphin_object)

# Save results
save_profiling_output(targeted_profiling, output_dir_10_rDolphin)

save_profiling_plots(
    output_dir_10_rDolphin, targeted_profiling$final_output,
    targeted_profiling$reproducibility_data
)

# Additionally, you can run some stats
intensities <- targeted_profiling$final_output$intensity
group <- as.factor(rDolphin_object$Metadata$type)
model_PLS <- rdCV_PLS_RF(X = intensities, Y = group)
}
}
\seealso{
Other import/export functions: 
\code{\link{Pipelines}},
\code{\link{load_and_save_functions}},
\code{\link{nmr_data}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_read_bruker_fid}()},
\code{\link{nmr_read_samples}()},
\code{\link{nmr_zip_bruker_samples}()},
\code{\link{save_files_to_rDolphin}()},
\code{\link{save_profiling_output}()},
\code{\link{to_ChemoSpec}()}
}
\concept{import/export functions}
