% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Response.R
\name{Response}
\alias{Response}
\alias{flatten,response-method}
\alias{flatten}
\alias{str,response-method}
\alias{as.list.response}
\alias{flatten,httr2_response-method}
\title{Process service responses to tibble and other data structures.}
\usage{
flatten(x)

\S4method{flatten}{response}(x)

\S4method{str}{response}(object)

\method{as.list}{response}(x, ..., as = c("text", "raw", "parsed"))

\S4method{flatten}{httr2_response}(x)
}
\arguments{
\item{x}{A \code{response} object returned by the service.}

\item{object}{A \code{response} object returned by the service.}

\item{\dots}{not currently used}

\item{as}{character(1); one of 'raw', 'text', 'parsed'}
}
\value{
\code{flatten()} returns a \code{tibble} where each row correseponds
to a top-level list element of the return value, and columns
are the unlisted second and more-nested elements.

\code{str()} displays a compact representation of the list-like
JSON response; it returns \code{NULL}.

\code{as.list()} returns the content of the web service request
as a list.
}
\description{
Process service responses to tibble and other data structures.
}
\section{Functions}{
\itemize{
\item \code{flatten(response)}: Reduce httr response object to a two-dimensional table

\item \code{str(response)}: Create a compact representation of the list-like JSON
response

\item \code{flatten(httr2_response)}: Reduce httr2 request responses to two-dimensional table
form

}}
\examples{
if (AnVILGCP::gcloud_exists() && interactive()) {
    library(AnVIL)
    leonardo <- Leonardo()
    leonardo$listRuntimes() |> flatten()

    leonardo$getSystemStatus() |> str()

    leonardo$getSystemStatus() |> as.list()
}
}
\author{
M. Morgan, M. Ramos
}
