% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateNetwork.R
\name{escapeAnnotation}
\alias{escapeAnnotation}
\title{Escapes elements of list in annotation.}
\usage{
escapeAnnotation(annVec, col = COLLAPSE, esc = ESC)
}
\arguments{
\item{annVec}{vector of annotation strings}

\item{col}{term list separator character}

\item{esc}{escape character}
}
\value{
vector of annotation strings with elements escaped
}
\description{
In situations when a given list of annotation ID terms may not be well
formatted, and therefore not be interoperated as unique. For example, given
a list of HDO IDs: HDO:14, HDO:143, HDO:1433, and HDO:14330, a grep for the
term HDO:14 could return: HDO:143, HDO:1433, HDO:14330. To avoid this all
terms should be enclosed in escape characters, which unlikely to find within
annotation itself.
}
\details{
NOTE: spaces are treated as regular
characters, no trimming is applied before or after escaping.
}
\examples{
annVec<-apply(matrix(letters, ncol=13), 2, paste, collapse=';')
cbind(annVec, escapeAnnotation(annVec, ';', '|'))
}
\seealso{
unescapeAnnotation
}
