% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bridgeness.R
\name{getBridgeness}
\alias{getBridgeness}
\title{Calculate bridginess from consensus matrix}
\usage{
getBridgeness(gg, alg, conmat)
}
\arguments{
\item{gg}{igraph object}

\item{alg}{clustering algorithm}

\item{conmat}{consensus matrix calculated with that algorithm}
}
\value{
data.frame with first column contains vertex ID, if GeneName
attribute assigned to the vertices its value will be stored as a
second column, the last column contains bridginess values for the
}
\description{
Bridginess takes into account a vertices shared community membership
together with its local neighbourhood. It was proposed in
Nepusz et al., 2008 \url{doi:10.1103/PhysRevE.77.016107}.
}
\details{
Function assumes clustering already been performed by the clustering
algorithm, and its membership values stored in vertex attributes. If
clustering algorithm vertex  \code{alg} attribute is not found an
error will be issued.
}
\examples{
library(BioNAR)
karate <- make_graph("Zachary")
# We need vertex ID in the 'name' attribute of the vertex
V(karate)$name<-c(LETTERS,letters)[1:vcount(karate)]
gg <- calcClustering(karate, 'louvain')
cnmat <- makeConsensusMatrix(gg, N=10, alg = 'louvain', type = 2, mask = 10)
br<-getBridgeness(gg, alg = 'louvain', cnmat)
}
