% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcga.R
\name{generateTCGAMatrix}
\alias{generateTCGAMatrix}
\title{Generate TCGA Genotype Matrix}
\usage{
generateTCGAMatrix(
  rawData = suppressMessages(getRawTCGAData("TCGA-BLCA")),
  genes = c("TP53", "ARID1A", "KDM6A", "PIK3CA", "RB1", "EP300", "FGFR3", "CREBBP",
    "STAG2", "ATM")
)
}
\arguments{
\item{rawData}{Raw TCGA data generated using \code{getRawTCGAData}}

\item{genes}{Genes to generate genotype matrix on}
}
\value{
A genotype matrix where each row is a patient and each column is a gene
}
\description{
Generate TCGA Genotype Matrix
}
\examples{
generateTCGAMatrix(rawData = data.frame())
# generateTCGAMatrix()
}
