% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PathwayAnalysis.R
\name{pathwayWeightingRCBN}
\alias{pathwayWeightingRCBN}
\title{pathwayWeightingRCBN}
\usage{
pathwayWeightingRCBN(edgeProb, peMap)
}
\arguments{
\item{edgeProb}{Marginal edge probabilities}

\item{peMap}{Pathway-edge compatibility matrix}
}
\value{
The pathway weights (step 4 of the R-CBN algorithm)
}
\description{
pathwayWeightingRCBN
}
\examples{
dag <- matrix(c(2, 2, 4, 1, 3, 3), 3, 2)
lambda <- c(1, 4, 3, 2.5, 2)
x <- 4
pathP <- pathProbCBN(dag, lambda, x)
edgeProb <- edgeMarginalized(pathP, x)
peMap <- pathEdgeMapper(4)
pathwayWeightingRCBN(edgeProb, peMap)
}
