% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualizeProbabilities}
\alias{visualizeProbabilities}
\title{Visualize Pathway Probabilities}
\usage{
visualizeProbabilities(
  probabilities,
  outputFile = NULL,
  geneNames = as.character(1:inverseFactorial(length(probabilities))),
  geneColors = rainbow(length(geneNames), v = 0.5),
  columnTitles = TRUE
)
}
\arguments{
\item{probabilities}{List or matrix of probabilities for each pathway (matrix if multiple models)}

\item{outputFile}{File to output to; if none provided, a plot will be returned}

\item{geneNames}{Gene names; if single character, rendered in circles}

\item{geneColors}{Gene colors}

\item{columnTitles}{Include column titles}
}
\value{
Plot or file name
}
\description{
Visualize Pathway Probabilities
}
\examples{
visualizeProbabilities(c(0.05, 0.03, 0.12, 0.04, 0.02, 0, 0.05, 0.04, 0.05, 0.06, 0.04, 0.02, 0.03, 0.02, 0.05, 0.03, 0.01, 0.09, 0.06, 0.04, 0, 0.08, 0.05, 0.02))

visualizeProbabilities(c(0.05, 0.03, 0.12, 0.04, 0.02, 0, 0.05, 0.04, 0.05, 0.06, 0.04, 0.02, 0.03, 0.02, 0.05, 0.03, 0.01, 0.09, 0.06, 0.04, 0, 0.08, 0.05, 0.02), geneNames = c("AAAA", "BBBB", "CCCC", "DDDD"))

mat <- matrix(c(0.1, 0.3, 0, 0.2, 0.4, 0, 0.2, 0.2, 0.1, 0, 0.2, 0.3), ncol = 2)
visualizeProbabilities(mat, columnTitles = TRUE)
}
