% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleNeighbourhoodAnalysis.R
\name{cellTypesPerCellTypeGraphFromNbhdMatrix}
\alias{cellTypesPerCellTypeGraphFromNbhdMatrix}
\title{This function takes a neighbourhood-by-cell type
matrix and produces a directed igraph showing the
fractions of cells of each type in the neighbourhoods
around cells of each type.}
\usage{
cellTypesPerCellTypeGraphFromNbhdMatrix(
  nbhdByCellType,
  clusters,
  colours = NULL,
  selfEdges = FALSE,
  minWeight = 0,
  edgeWeighting = 20,
  edgeCurved = 0.2,
  arrowSize = 4,
  arrowWidth = 4,
  plotGraph = TRUE
)
}
\arguments{
\item{nbhdByCellType}{\itemize{
\item A matrix whose rows are neighbourhoods
each denoted by the cell at their center, whose columns are
cell types, and whose entries are counts.
}}

\item{clusters}{\itemize{
\item a named vector whose names are the cells
and whose entries are their seurat_clusters.
}}

\item{colours}{\itemize{
\item a named vector of colours used to colour the
vertices of the graph.  The names are the seurat_clusters
as character strings.
}}

\item{selfEdges}{\itemize{
\item a logical which determines whether to include
self edges.  Defaults to FALSE
}}

\item{minWeight}{\itemize{
\item Allows one to exclude edges of low weight.
Defaults to 0, thus including all edges.
}}

\item{edgeWeighting}{\itemize{
\item a parameter used to thicken the edges
in the display.  Defaults to 20.
}}

\item{edgeCurved}{\itemize{
\item a parameter to set curvature of the edges.
Defaults to 0.2
}}

\item{arrowSize}{\itemize{
\item a parameter to set arrow size. Defaults to 4.
}}

\item{arrowWidth}{\itemize{
\item a parameter to set arrow width. Defaults to 4.
}}

\item{plotGraph}{\itemize{
\item a logical which determines whether to
plot the graph.  Defaults to TRUE.
}}
}
\value{
This returns a directed igraph whose vertices are
the cell types and whose arrows indicate "ownership" of
cells of the target type by neighbourhoods of cells of the
source type.  Layout is done witht the FR algorithm and
coordinates are found in the coords attribute of G.  If colours
were supplied these are found in the color attribute of V(G).
Edge weights and widths are found in the weight and width
attributes of E(G).
}
\description{
This function takes a neighbourhood-by-cell type
matrix and produces a directed igraph showing the
fractions of cells of each type in the neighbourhoods
around cells of each type.
}
