% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleEdgeQualityControl.R
\name{edgeCutoffsByWatershed}
\alias{edgeCutoffsByWatershed}
\title{This finds proposed cutoffs for edge lengths by computing
the histogram of edge lengths for each cell type pair and
then using the watershed algorithm to find the hump of the
histogram containing the median.}
\usage{
edgeCutoffsByWatershed(annEdges, nbins = 15, tolerance = 10)
}
\arguments{
\item{annEdges}{\itemize{
\item a data frame with columns nodeA, nodeB, length
and cellTypePair as produced by edgeLengthsAndCellTypePairs.
}}

\item{nbins}{\itemize{
\item the number of bins for the histogram
}}

\item{tolerance}{\itemize{
\item the tolerance parameter for the watershed
algorithm.
}}
}
\value{
This returns a data frame with columns cellTypePair and
cutoff.
}
\description{
This finds proposed cutoffs for edge lengths by computing
the histogram of edge lengths for each cell type pair and
then using the watershed algorithm to find the hump of the
histogram containing the median.
}
\examples{
getExample = make.getExample()
centroids = getExample('centroids')
clusters = getExample('clusters')
delaunayNeighbours = getExample('delaunayNeighbours') 
annEdges =
    edgeLengthsAndCellTypePairs(delaunayNeighbours,clusters,centroids)
cutoffDF = edgeCutoffsByWatershed(annEdges)
}
