% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getGenotype}
\alias{getGenotype}
\alias{getGenotype,GbsrGenotypeData-method}
\title{Get genotype call data.}
\usage{
getGenotype(
  object,
  node = "raw",
  parents = FALSE,
  valid = TRUE,
  chr = NULL,
  phased = FALSE,
  ...
)

\S4method{getGenotype}{GbsrGenotypeData}(object, node, parents, valid, chr, phased)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{node}{Either of "raw", "filt", "cor", and "parents". See details.}

\item{parents}{A logical value or "only" whether to include data for
parents or not or to get data only for parents. Ignored if \verb{node = "parents}.}

\item{valid}{A logical value. See details.}

\item{chr}{A integer vector of indexes indicating chromosomes
to get read count data.}

\item{phased}{If set \code{TRUE} to \code{phased}, the function will return phased
genotype data in a P x N x M array where P, N, and M are the ploidy, number
of samples, and number of markers.}

\item{...}{Unused.}
}
\value{
An integer matirix of genotype data which is represented
by the number of reference alleles at each marker of each sample.
}
\description{
Genotype calls are retrieved from the GDS file linked to the given
\link{GbsrGenotypeData} object.
}
\details{
When \verb{node = "raw}, the raw genotype data stored in the "genotype/data" node
will be returned, while \verb{node = "filt} make the function to return the
filtered genotype data stored in the "annotation/format/FGT/data" that can
be generated via the \code{\link[=setCallFilter]{setCallFilter()}} function. \verb{node = "cor} indicates to
get the corrected genotype data stored in the "annotation/format/CGT/data"
that can be generated via the \code{\link[=estGeno]{estGeno()}} function. The estimated parental
genotypes, which also can be generated via the \code{\link[=estGeno]{estGeno()}} function and
stored in the "annotation/info/PGT" node, can be obtained with
\code{node = "parents"}.
If \code{valid = TRUE}, genotype calls for only valid marker and valid samples
will be obtained.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

geno <- getGenotype(gds)

# Close the connection to the GDS file.
closeGDS(gds)


}
\seealso{
\code{\link[=setCallFilter]{setCallFilter()}} and \code{\link[=estGeno]{estGeno()}}
}
