% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{histGBSR}
\alias{histGBSR}
\title{Draw histograms of specified statistics}
\usage{
histGBSR(
  x,
  stats = c("dp", "missing", "het"),
  target = c("marker", "sample"),
  binwidth = NULL,
  color = c(Marker = "darkblue", Sample = "darkblue"),
  fill = c(Marker = "skyblue", Sample = "skyblue")
)
}
\arguments{
\item{x}{A \link{GbsrGenotypeData} object.}

\item{stats}{A string to specify statistics to be drawn.}

\item{target}{Either or both of "marker" and "sample", e.g. \code{target = "marker"}
to draw a histogram only for SNPs.}

\item{binwidth}{An integer to specify bin width of the histogram.
This value is passed to the ggplot function.}

\item{color}{A named vector "Marker" and "Sample" to specify border
color of bins in the histograms.}

\item{fill}{A named vector "Marker" and "Sample" to specify fill
color of bins in the histograms.}
}
\value{
A ggplot object.
}
\description{
Draw histograms of specified statistics
}
\details{
You can draw histograms of several summary statistics of genotype counts
and read counts per sample and per marker. The "stats" argument can take
the following values:
\describe{
\item{missing}{Proportion of missing genotype calls.}
\item{het}{Proportion of heterozygote calls.}
\item{raf}{Reference allele frequency.}
\item{dp}{Total read counts.}
\item{ad_ref}{Reference allele read counts.}
\item{ad_alt}{Alternative allele read counts.}
\item{rrf}{Reference allele read frequency.}
\item{mean_ref}{Mean of reference allele read counts.}
\item{sd_ref}{Standard deviation of reference allele read counts.}
\item{median_ref}{Quantile of reference allele read counts.}
\item{mean_alt}{Mean of alternative allele read counts.}
\item{sd_alt}{Standard deviation of alternative allele read counts.}
\item{median_alt}{Quantile of alternative allele read counts.}
\item{mq}{Mapping quality.}
\item{fs}{Phred-scaled p-value (strand bias)}
\item{qd}{Variant Quality by Depth}
\item{sor}{Symmetric Odds Ratio (strand bias)}
\item{mqranksum}{Alt vs. Ref read mapping qualities}
\item{readposranksum}{Alt vs. Ref read position bias}
\item{baseqranksum}{Alt Vs. Ref base qualities}
}

To draw histograms for "missing", "het", "raf", you need to run
\code{\link[=countGenotype]{countGenotype()}} first to obtain statistics. Similary, "dp",
"ad_ref", "ad_alt", "rrf" requires values obtained via
\code{\link[=countRead]{countRead()}}. "mq", "fs", "qd", "sor", "mqranksum", "readposranksum",
and "baseqranksum" only work with \code{target = "marker"}, if your data
contains those values supplied via SNP calling tools like
\href{https://gatk.broadinstitute.org/hc/en-us}{GATK}.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Summarize genotype count information to be used in `histGBSR()`
gds <- countGenotype(gds)

# Draw histograms of missing rate, heterozygosity, and reference
# allele frequency per SNP and per sample.
histGBSR(gds, stats = "missing")

# Close the connection to the GDS file
closeGDS(gds)
}
