% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R,
%   R/Methods-GbsrScheme.R
\name{initScheme}
\alias{initScheme}
\alias{initScheme,GbsrGenotypeData-method}
\alias{initScheme,GbsrScheme-method}
\title{Build a \link{GbsrScheme} object}
\usage{
initScheme(object, mating, ...)

\S4method{initScheme}{GbsrGenotypeData}(object, mating)

\S4method{initScheme}{GbsrScheme}(object, mating, parents)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{mating}{An integer matrix to indicate mating combinations.
The each element should match with IDs of
parental samples which are 1 to N. see Details.}

\item{...}{Unused.}

\item{parents}{Indices of parental lines.}
}
\value{
A \link{GbsrGenotypeData} object storing
a \link{GbsrScheme} object in the "scheme" slot.
}
\description{
\link{GBScleanR} uses breeding scheme information to set the expected
number of cross overs in a chromosome which is a required parameter
for the genotype error correction with the hidden Markov model
implemented in the \code{\link[=estGeno]{estGeno()}} function.
This function build the object storing
type crosses performed at each generation of breeding and population sizes.
}
\details{
A \link{GbsrScheme} object stores information of a population size,
mating combinations and
a type of cross applied to each generation of the breeding process
to generate the population which you are going to subject
to the \code{\link[=estGeno]{estGeno()}} function.
The first generation should be parents of the population.
It is supposed that
\code{\link[=setParents]{setParents()}} has been already executed and parents
are labeled in the
\link{GbsrGenotypeData} object. The number of parents
are automatically recognized.
The "crosstype" of the first generation can be
"pairing" or "random" with
\code{pop_size = N}, where N is the number of parents.
You need to specify a matrix indicating combinations
of \code{mating}, in which each column shows
a pair of parental samples. For example, if you have
only two parents, the \code{mating} matrix
is \code{mating = cbind(c(1:2))}. The indices used in the matrix
should match with the IDs labeled to parental samples by \code{\link[=setParents]{setParents()}}.
The created \link{GbsrScheme} object is set
in the \code{scheme} slot of the \link{GbsrGenotypeData} object.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Biparental F2 population.
gds <- setParents(gds, parents = c("Founder1", "Founder2"))

# setParents gave member ID 1 and 2 to Founder1 and Founder2, respectively.
gds <- initScheme(gds, mating = cbind(c(1:2)))

# Now the progenies of the cross above have member ID 3.
# If `crosstype = "selfing"` or `"sibling"`, you can omit a `mating` matrix.
gds <- addScheme(gds, crosstype = "self")

# Now you can execute `estGeno()` which requires a [GbsrScheme] object.

# Close the connection to the GDS file
closeGDS(gds)

}
\seealso{
\code{\link[=addScheme]{addScheme()}} and \code{\link[=showScheme]{showScheme()}}
}
