% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdcClinical.R
\name{gdcClinicalDownload}
\alias{gdcClinicalDownload}
\title{Download clinical data in GDC}
\usage{
gdcClinicalDownload(manifest = NULL, project.id,
  directory = "Clinical", write.manifest = FALSE,
  method = "gdc-client")
}
\arguments{
\item{manifest}{menifest file that is downloaded from the GDC cart. 
If provided, files whose UUIDs are in the manifest file will be 
downloaded via gdc-client, otherwise, \code{project id} argument 
should be provided to download data automatically. 
Default is \code{NULL}}

\item{project.id}{project id in GDC}

\item{directory}{the folder to save downloaded files. 
Default is \code{'Clinical'}}

\item{write.manifest}{logical, whether to write out the manifest file}

\item{method}{method that is used to download data. Either 
\code{'GenomicDataCommons'} which is a well established method 
developed in the \pkg{GenomicDataCommons'} package, or alternatively 
\code{'gdc-client'} which uses the \code{gdc-client} tool developed 
by GDC. Default is \code{'gdc-client'}.}
}
\value{
downloaded files in the specified directory
}
\description{
Download clinical data in GDC 
    either by providing the manifest file or 
    specifying the project id and data type
}
\examples{
####### Download Clinical data by manifest file #######
manifest <- 'Clinical.manifest.txt'
\dontrun{gdcClinicalDownload(manifest  = manifest,
                    directory = 'Clinical')}
                   
####### Download Clinical data by project id #######
project <- 'TCGA-PRAD'
\dontrun{gdcClinicalDownload(project.id     = project, 
                    write.manifest = TRUE,
                    directory      = 'Clinical')}
}
\author{
Ruidong Li and Han Qu
}
