% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facets.R
\name{facet}
\alias{facet}
\alias{get_facets}
\alias{get_facets.GDCQuery}
\title{Set facets for a \code{\link{GDCQuery}}}
\usage{
facet(x, facets)

get_facets(x)

\method{get_facets}{GDCQuery}(x)
}
\arguments{
\item{x}{a \code{\link{GDCQuery}} object}

\item{facets}{a character vector of fields that
will be used for forming aggregations (facets).
Default is to set facets for all default fields.
See \code{\link{default_fields}} for details}
}
\value{
returns a \code{\link{GDCQuery}} object,
with facets field updated.
}
\description{
Set facets for a \code{\link{GDCQuery}}

Get facets for a \code{\link{GDCQuery}}
}
\examples{
# create a new GDCQuery against the projects endpoint
gProj = projects()

# default facets are NULL
get_facets(gProj)

# set facets and save result
gProjFacet = facet(gProj)

# check facets
get_facets(gProjFacet)

# and get a response, noting that
# the aggregations list member contains
# tibbles for each facet
str(response(gProjFacet,size=2),max.level=2)

}
