% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadData.R
\name{handle_bedGraph}
\alias{handle_bedGraph}
\title{Handle files in bedGraph format}
\usage{
handle_bedGraph(inputFile, importParams = NULL, verbose = FALSE)
}
\arguments{
\item{inputFile}{a string denoting path to the input file}

\item{importParams}{a list of parameters, refer to \code{\link{handle_input}}
for details}

\item{verbose}{logical, whether to output additional information}
}
\value{
a list object with four elements, 'query' is a list GRanges objects
or RleList objects, 'size' is the library size, 'type' is the input file
type, 'weight' is the name of the metadata column to be used as weight for
coverage calculation
}
\description{
This is a function for read peaks data in bedGraph format,
store the input data in a list of GRanges objects or RleList objects.
}
\examples{
queryFiles <- system.file("extdata", "test_chr19.bedGraph",
    package = "GenomicPlot"
)
names(queryFiles) <- "chipPeak"

importParams <- setImportParams(
    offset = 0, fix_width = 0, fix_point = "start", norm = FALSE,
    useScore = TRUE, outRle = FALSE, useSizeFactor = FALSE, genome = "hg19",
    val = 4, skip = 1
)

out <- handle_bedGraph(queryFiles, importParams, verbose = TRUE)
out$query

}
\author{
Shuye Pu
}
