% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateFalseDiscoveryRate.R
\name{calculateFalseDiscoveryRate}
\alias{calculateFalseDiscoveryRate}
\title{Calculate False Discovery Rate (FDR) Using Permuted Values (Adjusted)}
\usage{
calculateFalseDiscoveryRate(observedValues, permutedValues)
}
\arguments{
\item{observedValues}{Numeric vector. The observed test statistics or values
to be evaluated for significance.}

\item{permutedValues}{Numeric matrix. The permuted test statistics or values,
with rows corresponding to the same values as in \code{observedValues} and
columns representing different permutations.}
}
\value{
A numeric vector of the same length as \code{observedValues}, containing
the estimated FDR for each observed value.
}
\description{
This function calculates the false discovery rate (FDR) by comparing
observed values to permuted values.The function sorts observed values,
compares them against permuted data, and computes FDR using the median of
permutation results.
}
