% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boot_parallel.R
\name{Boot_parallel}
\alias{Boot_parallel}
\title{Parallel processing handling function}
\usage{
Boot_parallel(
  BPPARAM = NULL,
  samples,
  data,
  formula.str,
  group.name,
  groups,
  meta.info,
  a1,
  a2,
  pSamples
)
}
\arguments{
\item{BPPARAM}{A parallel BPPARAM object for distributed computation.}

\item{samples}{bootstrapped samples matrix}

\item{data}{A \code{SummarizedExperiment} object or a matrix where rows
represent features (e.g., genes, proteins) and columns represent samples.
The values should be log-transformed.}

\item{formula.str}{A formula string used when covariates are present in meta.
info for modeling. It should include "~ 0 + ..." to exclude the
intercept from the model.}

\item{group.name}{A string specifying the column in \code{meta.info} that
represents the groups or conditions for comparison.}

\item{groups}{groups information from \code{meta.info}}

\item{meta.info}{A data frame containing sample-level metadata, where each
row corresponds to a sample. It should include the grouping variable
specified in \code{group.name}. If \code{x} is a \code{SummarizedExperiment}
object, \code{meta.info} must be a vector of the metadata needed for the
model to run and can be retrieved using \code{colData()}.}

\item{a1}{Optional numeric value used in the optimization process.
If defined by the user, no optimization occurs.}

\item{a2}{Optional numeric value used in the optimization process.
If defined by the user, no optimization occurs.}

\item{pSamples}{a permutated list of samples}
}
\value{
A list containing: \code{D, S, pD, pS} for bootstrapped data and
for permuted data.
}
\description{
Parallel processing handling function
}
