% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Limma_fit.R
\name{Limma_fit}
\alias{Limma_fit}
\title{Perform Linear Modeling with Covariates using Limma}
\usage{
Limma_fit(x, group.name, meta.info, formula.str, trend, robust)
}
\arguments{
\item{x}{A list containing two or more data matrices where rows represent
features (e.g., genes, proteins) and columns represent samples. The list
should contain at least two matrices for pairwise group comparison.}

\item{group.name}{A character string indicating the name of the group
variable in\code{meta.info} to be used in the analysis.}

\item{meta.info}{A data frame containing the metadata for the samples.
This includes sample grouping and any covariates to be included in the model.}

\item{formula.str}{A string specifying the formula to be used in model
fitting. It should follow the standard R formula syntax
(e.g., \code{~ covariate1 + covariate2}).}

\item{trend}{A logical value indicating whether to allow for an
intensity-dependent trend in the prior variance.}

\item{robust}{A logical value indicating whether to use a robust fitting
procedure to protect against outliers.}
}
\value{
A list containing the following elements:
\item{d}{A vector of the test statistics (log-fold changes or F-statistics)
for each feature.}
\item{s}{A vector of the standard deviations for each feature, adjusted by t
he empirical Bayes procedure.}
\item{corrected.logfc}{The log-fold changes for each feature after fitting
the model.}
}
\description{
This function performs linear modeling using the Limma package, incorporating
covariates in the model fitting process. It is designed to handle both
two-group comparisons and multi-group settings with covariates.
}
\details{
This function combines the data matrices from different groups and fits a
linear model using covariates provided in the \code{meta.info}. For two-group
comparisons, the function computes contrasts between the two groups and
applies empirical Bayes moderation. For multi-group analysis with a single
covariate, pairwise contrasts are computed, and the moderated F-statistic is
calculated for each feature.
}
\seealso{
\code{\link[limma]{lmFit}},
\code{\link[limma]{eBayes}},
\code{\link[limma]{topTable}},
\code{\link[limma]{makeContrasts}}
}
