% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Limma_bootstrap.r
\name{Limma_bootstrap}
\alias{Limma_bootstrap}
\title{Perform Linear Modeling with Covariates using Limma}
\usage{
Limma_bootstrap(x, group.name, meta.info, formula.str)
}
\arguments{
\item{x}{A list containing two or more data matrices where rows represent
features (e.g., genes, proteins) and columns represent samples. The list
should contain at least two matrices for pairwise group comparison.}

\item{group.name}{A character string indicating the name of the group
variable in \code{meta.info} to be used in the analysis.}

\item{meta.info}{A data frame containing the metadata for the samples.
This includes sample grouping and any covariates to be included in the model.}

\item{formula.str}{A string specifying the formula to be used in model
fitting. It should follow the standard R formula syntax
(e.g., \code{~ covariate1 + covariate2}).}
}
\value{
A list containing the following elements:
\item{d}{A vector of the test statistics (log-fold changes or F-statistics)
for each feature.}
\item{s}{A vector of the standard deviations for each feature, adjusted by
the empirical Bayes procedure.}
}
\description{
This function performs linear modeling using the Limma package while
accounting for covariates specified
in the \code{meta.info}. It supports two-group comparisons and multi-group
analysis, incorporating covariates
through a design matrix.
}
\details{
This function first combines the data matrices from different groups and
prepares a design matrix based on the covariates specified in \code{meta.info}
using the provided formula. It fits a linear model using Limma,
computes contrasts between groups, and applies empirical Bayes moderation.
For two-group comparisons, the function returns log-fold changes and
associated statistics. In multi-group settings with a single covariate,
it calculates pairwise contrasts and moderated F-statistics.
}
\seealso{
\code{\link[limma]{lmFit}}, \code{\link[limma]{eBayes}},
\code{\link[limma]{topTable}},
\code{\link[limma]{makeContrasts}}
}
