% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getResult.R
\name{getResult}
\alias{getResult}
\alias{getResult,MgnifyClient-method}
\title{Get microbial and/or functional profiling data for a list of accessions}
\usage{
getResult(x, ...)

\S4method{getResult}{MgnifyClient}(
  x,
  accession,
  get.taxa = TRUE,
  get.func = TRUE,
  output = "TreeSE",
  ...
)
}
\arguments{
\item{x}{A \code{MgnifyClient} object.}

\item{...}{optional arguments:
\itemize{
  
  \item \strong{taxa.su} A single character value specifying which taxa
  subunit results should be selected. Currently, taxonomy assignments in the
  MGnify pipelines rely on rRNA matches to existing databases
  (GreenGenes and SILVA), with later pipelines checking both the SSU and
  LSU portions of the rRNA sequence. \code{taxa.su} allows then selection
  of either the Small subunit (\code{"SSU"}) or Large subunit (\code{"LSU"})
  results in the final \code{TreeSummarizedExperiment} object. Older pipeline
  versions do not report results for both subunits, and thus for some
  accessions this value will have no effect.

  \item \strong{get.tree} A single boolean value specifying whether to
  include available phylogenetic trees in the \code{TreeSummarizedExperiment}
  object. Available when \code{get.taxa = TRUE}.
  (By default: \code{get.tree = TRUE})

  \item \strong{as.df} A single boolean value enabled when
  \code{output = "list"}. The argument specifies whether return functional
  data as a named list (one entry per element in the output list) of
  data.frames, with each data.frame containing results for all requested
  accessions. If \code{FALSE}, the function returns a list of lists, each
  element consisting of results for a single accession. (By default:
  \code{as.df = TRUE})

  \item \strong{bulk.dl} A single boolean value specifying should
  MGnifyR attempt to speed things up by downloading
  relevant studies TSV results and only extracting the required columns,
  rather than using the JSONAPI interface. When getting results where
  multiple accessions share the same study, this option may result in
  significantly faster processing. However, there appear to be (quite a few)
  cases in the database where the TSV result columns do NOT match the
  expected accession names. This will hopefully be fixed in the future,
  but for now \code{bulk.dl} defaults to TRUE. When it does work, it can
  be orders of magnitude more efficient.
  (By default: \code{buld_dl = TRUE})

}}

\item{accession}{A single character value or a vector of character values
specifying accession IDs to return results for.}

\item{get.taxa}{A boolean value specifying whether to retrieve taxonomy
data (OTU table). See \code{taxa.su} for specifying taxonomy type. The
data is retrieved as BIOM files which are subsequently parsed.
(By default: \code{get.taxa = TRUE})}

\item{get.func}{A boolean value or a single character value or a vector
character values specifying functional analysis types to retrieve. If
\code{get.func = TRUE}, all available functional datatypes are retrieved,
and if \code{FALSE}, functional data is not retrieved. The current list of
available types is \code{"antismash-gene-clusters"}, \code{"go-slim"},
\code{"go-terms"}, \code{"interpro-identifiers"}, \code{"taxonomy"},
\code{"taxonomy-itsonedb"}, \code{"taxonomy-itsunite"}, \code{"taxonomy-lsu"},
and \code{"taxonomy-ssu"}. Note that depending on the particular analysis
type, pipeline version etc., not all functional results will be available.
Furthermore, taxonomy is also available via \code{get.func}, and loading
the data might be considerable faster if \code{bulk.dl = TRUE}. However,
phylogeny is available only via \code{get.taxa}.
(By default: \code{get.func = TRUE})}

\item{output}{A single character value specifying the format of an output.
Must be one of the following options: \code{"TreeSE"}, \code{"list"}, or 
\code{"phyloseq"}. (By default: \code{output = "TreeSE"})}
}
\value{
If only taxonomy data is retrieved, the result is returned in
\code{TreeSummarizedExperiment} object by default. The result can also be
returned as a \code{phyloseq} object or as a list of \code{data.frames}.
Note that \code{phyloseq} object can include only one phylogenetic tree
meaning that some taxa might be lost when data is subsetted based on tree.

When functional data is retrieved in addition to taxonomy data, the result
is returned as a \code{MultiAssayExperiment} object. Other options are a list
containing \code{phyloseq} object and \code{data.frames} or just
\code{data.frames}.

Functional data can be returned as a \code{MultiAssayExperiment} object or
as a list of \code{data.frames}.
}
\description{
Get microbial and/or functional profiling data for a list of accessions
}
\details{
Given a set of analysis accessions and collection of annotation types,
the function queries the MGNify API and returns the results. This function
is convenient for retrieving highly structured (analysis vs counts) data on
certain instances. For example, BIOM files are downloaded automatically.
If you want just to retrieve raw data from the database, see \code{getData}.
}
\examples{
# Create a client object
mg <- MgnifyClient(useCache = FALSE)

# Get OTU tables as TreeSE
accession_list <- c("MGYA00377505")
tse <- getResult(mg, accession_list, get.func=FALSE, get.taxa=TRUE)

\dontrun{
# Get functional data along with OTU tables as MAE
mae <- getResult(mg, accession_list, get.func=TRUE, get.taxa=TRUE)

# Get same data as list
list <- getResult(
    mg, accession_list, get.func=TRUE, get.taxa=TRUE, output = "list",
    as.df = TRUE, use.cache = TRUE)
}

}
\seealso{
\code{\link[MGnifyR:getData]{getData}}
}
