% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates_dynamics.R
\name{estimates_dynamics}
\alias{estimates_dynamics}
\title{Extracts parameter estimates from numeric fit of Bayesian model of dynamics}
\usage{
estimates_dynamics(
  data,
  assay = "scaled_log",
  fit = metadata(data)[["dynamic_fit"]]
)
}
\arguments{
\item{data}{data frame or colData of a \link[SummarizedExperiment]{SummarizedExperiment}
used to fit dynamics model, must contain a column named "condition" specifiyng
the experimental condition and a column
named "time" specifying the timepoints.
If it is a SummarizedExperiment object the dynamic fits must be stores in metadata(data)
under "dynamic_fits"}

\item{assay}{of the SummarizedExperiment object that was used to fit the dynamics
model}

\item{fit}{model fit for which estimates should be extracted}
}
\value{
a list of dataframes (one per parameters mu, sigma, lambda, delta_mu and euclidean distance) that contains
the estimates:
mu: is the estimated mean metabolite abundance
sigma: the estimated standard deviation of metabolite abundance
lambda: pooled sigma per condition
delta_mu: differences of mu between time points
euclidean_distances: estimated euclidean distance of time vectors of one metabolite between conditions
If data is a summarizedExperiment object the estimates are stored in
metadata(data) under "estimates_dynamics"
}
\description{
Extracts the mean concentrations (mu) at every time point from the dynamics model fit, the 95\% highest density interval (HDI), the estimated standard deviation of metabolite concentrations at every time point (sigma), and the pooled standard deviation of every metabolite over all timepoints (lambda).
Additionally samples from the posterior of mu can be drawn. This can be helpful if p.e. one wants to estimate the clustering precision. Lambda can be used for clustering algorithms such as VSClust that also take the variance into account.
}
\examples{
data("longitudinalMetabolomics")
data <- longitudinalMetabolomics[, longitudinalMetabolomics$condition == "A" &
  longitudinalMetabolomics$metabolite == "ATP"]
data <- fit_dynamics_model(
  data = data,
  scaled_measurement = "m_scaled", assay = "scaled_log",
  max_treedepth = 14, adapt_delta = 0.95, iter = 2000, cores = 1, chains = 1
)
data <- estimates_dynamics(
  data = data
)
S4Vectors::metadata(data)[["estimates_dynamics"]]
}
\seealso{
Fit the dynamic model \code{\link[=fit_dynamics_model]{fit_dynamics_model()}}.
Diagnostics of the dynamic model \code{\link[=diagnostics_dynamics]{diagnostics_dynamics()}}
Visualization of estimates with \code{\link[=plot_estimates]{plot_estimates()}}
}
