% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-io.R
\name{ImportDada2}
\alias{ImportDada2}
\alias{import_dada2}
\alias{mp_import_dada2}
\title{Import function to load the feature table and taxonomy table of dada2}
\usage{
import_dada2(seqtab, taxatab = NULL, reftree = NULL, sampleda = NULL, ...)

mp_import_dada2(seqtab, taxatab = NULL, reftree = NULL, sampleda = NULL, ...)
}
\arguments{
\item{seqtab}{matrix, feature table, the output of \code{\link[dada2]{removeBimeraDenovo}}.}

\item{taxatab}{matrix, a taxonomic table, the output of \code{\link[dada2]{assignTaxonomy}},
or the ouput of \code{\link[dada2]{addSpecies}}.}

\item{reftree}{phylo, treedata or character, the treedata or phylo class of tree, or the tree file.}

\item{sampleda}{data.frame or character, the data.frame of sample information,
or the file of sample information, nrow samples X ncol factors.}

\item{..., }{additional parameters.}
}
\value{
phyloseq class contained the argument class.
}
\description{
the function can import the ouput of dada2, and generated the phyloseq obj contained the
argument class.
}
\examples{
seqtabfile <- system.file("extdata", "seqtab.nochim.rds",
                          package="MicrobiotaProcess")
taxafile <- system.file("extdata", "taxa_tab.rds",
                        package="MicrobiotaProcess")
seqtab <- readRDS(seqtabfile)
taxa <- readRDS(taxafile)
sampleda <- system.file("extdata", "mouse.time.dada2.txt", 
                        package="MicrobiotaProcess")
mpse <- mp_import_dada2(seqtab=seqtab, taxatab=taxa,
                   sampleda=sampleda)
mpse
}
\author{
Shuangbin Xu
}
