% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-diff-analysis.R
\name{diff_analysis}
\alias{diff_analysis}
\alias{diff_analysis.data.frame}
\alias{diff_analysis.phyloseq}
\title{Differential expression analysis}
\usage{
diff_analysis(obj, ...)

\method{diff_analysis}{data.frame}(
  obj,
  sampleda,
  classgroup,
  subclass = NULL,
  taxda = NULL,
  alltax = TRUE,
  include.rownames = FALSE,
  standard_method = NULL,
  mlfun = "lda",
  ratio = 0.7,
  firstcomfun = "kruskal.test",
  padjust = "fdr",
  filtermod = "pvalue",
  firstalpha = 0.05,
  strictmod = TRUE,
  fcfun = "generalizedFC",
  secondcomfun = "wilcox.test",
  clmin = 5,
  clwilc = TRUE,
  secondalpha = 0.05,
  subclmin = 3,
  subclwilc = TRUE,
  ldascore = 2,
  normalization = 1e+06,
  bootnums = 30,
  ci = 0.95,
  type = "species",
  ...
)

\method{diff_analysis}{phyloseq}(obj, ...)
}
\arguments{
\item{obj}{object,a phyloseq class contained otu_table, sample_data, taxda, 
or data.frame, nrow sample * ncol features.}

\item{..., }{additional parameters.}

\item{sampleda}{data.frame, nrow sample * ncol factor, the sample names of 
sampleda and data should be the same.}

\item{classgroup}{character, the factor name in sampleda.}

\item{subclass}{character, the factor name in sampleda, default is NULL, 
meaning no subclass compare.}

\item{taxda}{data.frame, the classification of the feature in data. 
default is NULL.}

\item{alltax}{logical, whether to set all classification (taxonomy) as features when \code{taxda} is not NULL, 
default is TRUE.}

\item{include.rownames}{logical, whether to consider the OTU of \code{obj} as (all taxonomy) features, when 
\code{taxda} is not NULL, default is FALSE.}

\item{standard_method}{character, the method of standardization, 
see also \code{\link[vegan]{decostand}}, default is NULL, 
it represents that the relative abundance of taxonomy will be used. If count was set,
it represents the count reads of taxonomy will be used.}

\item{mlfun}{character, the method for calculating the effect size of features, 
choose "lda" or "rf", default is "lda".}

\item{ratio}{numeric, range from 0 to 1, the proportion of samples for calculating the effect 
size of features, default is 0.7.}

\item{firstcomfun}{character, the method for first test, "oneway.test" for normal distributions, 
suggested choosing "kruskal.test" for uneven distributions, default is "kruskal.test", or
you can use lm, glm, or glm.nb (for negative binomial distribution), or `kruskal_test`, 
`oneway_test` of `coin`.}

\item{padjust}{character, the correction method, default is "fdr".}

\item{filtermod}{character, the method to filter, default is "pvalue".}

\item{firstalpha}{numeric, the alpha value for the first test, default is 0.05.}

\item{strictmod}{logical, whether to performed in one-against-one, default is TRUE (strict).}

\item{fcfun}{character, default is "generalizedFC", it can't be set another at the present time.}

\item{secondcomfun}{character, the method for one-against-one, default is "wilcox.test" for 
uneven distributions, or `wilcox_test` of `coin`, or you can also use `lm`,
`glm`, `glm.nb`(for negative binomial distribution in `MASS`).}

\item{clmin}{integer, the minimum number of samples per classgroup for performing test, default is 5.}

\item{clwilc}{logical, whether to perform test of per classgroup, default is TRUE.}

\item{secondalpha}{numeric, the alpha value for the second test, default is 0.05.}

\item{subclmin}{integer, the minimum number of samples per suclass for performing test, default is 3.}

\item{subclwilc}{logical, whether to perform test of per subclass, default is TRUE, meaning more strict.}

\item{ldascore}{numeric, the threshold on the absolute value of the logarithmic LDA score, default is 2.}

\item{normalization}{integer, set the normalization value, set a big number if to get more meaningful values 
for the LDA score, or you can set NULL for no normalization, default is 1000000.}

\item{bootnums}{integer, set the number of bootstrap iteration for lda or rf, default is 30.}

\item{ci}{numeric, the confidence interval of effect size (LDA or MDA), default is 0.95.}

\item{type}{character, the type of datasets, default is "species", if the dataset is not about species, 
such as dataset of kegg function, you should set it to "others".}
}
\value{
diff_analysis class.
}
\description{
Differential expression analysis
}
\examples{
\dontrun{
data(kostic2012crc)
kostic2012crc \%<>\% as.phyloseq()
head(phyloseq::sample_data(kostic2012crc),3)
kostic2012crc <- phyloseq::rarefy_even_depth(kostic2012crc,rngseed=1024)
table(phyloseq::sample_data(kostic2012crc)$DIAGNOSIS)
set.seed(1024)
diffres <- diff_analysis(kostic2012crc, classgroup="DIAGNOSIS",
                        mlfun="lda", filtermod="fdr",
                        firstcomfun = "kruskal.test",
                        firstalpha=0.05, strictmod=TRUE,
                        secondcomfun = "wilcox.test",
                        subclmin=3, subclwilc=TRUE,
                        secondalpha=0.01, ldascore=3)
}
}
\author{
Shuangbin Xu
}
