% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-ggbox.R
\name{ggbox}
\alias{ggbox}
\alias{ggbox,data.frame-method}
\alias{ggbox,data.frame}
\alias{ggbox,alphasample-method}
\alias{ggbox,alphasample}
\title{A box or violin plot with significance test}
\usage{
ggbox(obj, factorNames, ...)

\S4method{ggbox}{data.frame}(
  obj,
  sampleda,
  factorNames,
  indexNames,
  geom = "boxplot",
  factorLevels = NULL,
  compare = TRUE,
  testmethod = "wilcox.test",
  signifmap = FALSE,
  p_textsize = 2,
  step_increase = 0.1,
  boxwidth = 0.2,
  facetnrow = 1,
  controlgroup = NULL,
  comparelist = NULL,
  ...
)

\S4method{ggbox}{alphasample}(obj, factorNames, ...)
}
\arguments{
\item{obj}{object, alphasample or data.frame (row sample x column features).}

\item{factorNames}{character, the names of factor contained in sampleda.}

\item{...}{additional arguments, see also \code{\link[ggsignif]{stat_signif}}.}

\item{sampleda}{data.frame, sample information if obj is data.frame, the 
sampleda should be provided.}

\item{indexNames}{character, the vector character, should be the names of 
features contained object.}

\item{geom}{character, "boxplot" or "violin", default is "boxplot".}

\item{factorLevels}{list, the levels of the factors, default is NULL,
if you want to order the levels of factor, you can set this.}

\item{compare}{logical, whether test the features among groups,default is TRUE.}

\item{testmethod}{character, the method of test, default is `wilcox.test`.
see also \code{\link[ggsignif]{stat_signif}}.}

\item{signifmap}{logical, whether the pvalue are directly written a annotaion
or asterisks are used instead, default is (pvalue) FALSE. see also
\code{\link[ggsignif]{stat_signif}}.}

\item{p_textsize}{numeric, the size of text of pvalue or asterisks, 
default is 2.}

\item{step_increase}{numeric, see also \code{\link[ggsignif]{stat_signif}},
default is 0.1.}

\item{boxwidth}{numeric, the width of boxplot when the geom is 'violin',
default is 0.2.}

\item{facetnrow}{integer, the nrow of facet, default is 1.}

\item{controlgroup}{character, the names of control group, if it was set, the other groups 
will compare to it, default is NULL.}

\item{comparelist}{list, the list of vector, default is NULL.}
}
\value{
a 'ggplot' plot object, a box or violine plot.
}
\description{
A box or violin plot with significance test
}
\examples{
\dontrun{
library(magrittr)
otudafile <- system.file("extdata", "otu_tax_table.txt",
                         package="MicrobiotaProcess")
otuda <- read.table(otudafile, sep="\t", 
                    header=TRUE, row.names=1,
                    check.names=FALSE, skip=1, 
                    comment.char="")
samplefile <- system.file("extdata",
                          "sample_info.txt", 
                          package="MicrobiotaProcess")
sampleda <- read.table(samplefile,
                       sep="\t", header=TRUE, row.names=1)
otuda <- otuda[sapply(otuda, is.numeric)] \%>\% t() \%>\%
         data.frame(check.names=FALSE)
set.seed(1024)
alphaobj1 <- get_alphaindex(otuda, sampleda=sampleda)
p1 <- ggbox(alphaobj1, factorNames="group")
data(test_otu_data)
test_otu_data \%<>\% as.phyloseq()
set.seed(1024)
alphaobj2 <- get_alphaindex(test_otu_data)
class(alphaobj2)
head(as.data.frame(alphaobj2))
p2 <- ggbox(alphaobj2, factorNames="group")
# set factor levels.
p3 <- ggbox(obj=alphaobj2, factorNames="group", 
            factorLevels=list(group=c("M", "N", "B", "D")))
# set control group.
p4 <- ggbox(obj=alphaobj2, factorNames="group", controlgroup="B")
 set comparelist
p5 <- ggbox(obj=alphaobj2, factorNames="group", 
            comparelist=list(c("B", "D"), c("B", "M"), c("B", "N")))
}
}
\author{
Shuangbin Xu
}
