% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_pca.R
\name{mp_cal_pca}
\alias{mp_cal_pca}
\alias{mp_cal_pca,MPSE-method}
\alias{mp_cal_pca,MPSE}
\alias{mp_cal_pca,tbl_mpse-method}
\alias{mp_cal_pca,tbl_mpse}
\alias{mp_cal_pca,grouped_df_mpse-method}
\alias{mp_cal_pca,grouped_df_mpse}
\title{Principal Components Analysis with MPSE or tbl_mpse object}
\usage{
mp_cal_pca(.data, .abundance, .dim = 3, action = "add", ...)

\S4method{mp_cal_pca}{MPSE}(.data, .abundance, .dim = 3, action = "add", ...)

\S4method{mp_cal_pca}{tbl_mpse}(.data, .abundance, .dim = 3, action = "add", ...)

\S4method{mp_cal_pca}{grouped_df_mpse}(.data, .abundance, .dim = 3, action = "add", ...)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated.}

\item{.dim}{integer The number of dimensions to be returned, default is 3.}

\item{action}{character "add" joins the pca result to the object, "only" return
a non-redundant tibble with the pca result. "get" return 'prcomp' object.}

\item{...}{additional parameters see also 'prcomp'}
}
\value{
update object or tbl according to the action.
}
\description{
Principal Components Analysis with MPSE or tbl_mpse object
}
\examples{
data(mouse.time.mpse)
library(ggplot2)
mpse <- mouse.time.mpse \%>\% 
          mp_decostand(.abundance=Abundance) \%>\% 
          mp_cal_pca(.abundance=hellinger, action="add")
mpse
p1 <- mpse \%>\% mp_plot_ord(.ord=pca, .group=time, ellipse=TRUE)
p2 <- mpse \%>\% mp_plot_ord(.ord=pca, .group=time, .color=time, ellipse=TRUE)
p1 + scale_fill_manual(values=c("#00AED7", "#009E73"))
p2 + scale_fill_manual(values=c("#00AED7", "#009E73")) +
     scale_color_manual(values=c("#00AED7", "#009E73"))
\dontrun{
# action = "only" to extract the non-redundant tibble to visualize
tbl <- mouse.time.mpse \%>\%
          mp_decostand(.abundance=Abundance) \%>\%
          mp_cal_pca(.abundance=hellinger, action="only")
tbl
x <- names(tbl)[grepl("PC1 ", names(tbl))] \%>\% as.symbol()
y <- names(tbl)[grepl("PC2 ", names(tbl))] \%>\% as.symbol()
ggplot(tbl) + 
 geom_point(aes(x=!!x, y=!!y, color=time))
}
}
\author{
Shuangbin Xu
}
