% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_rarecurve.R
\name{mp_cal_rarecurve}
\alias{mp_cal_rarecurve}
\alias{mp_cal_rarecurve,MPSE-method}
\alias{mp_cal_rarecurve,MPSE}
\alias{mp_cal_rarecurve,tbl_mpse-method}
\alias{mp_cal_rarecurve,tbl_mpse}
\alias{mp_cal_rarecurve,grouped_df_mpse-method}
\alias{mp_cal_rarecurve,grouped_df_mpse}
\title{Calculating the different alpha diversities index with different depth}
\usage{
mp_cal_rarecurve(
  .data,
  .abundance = NULL,
  action = "add",
  chunks = 400,
  seed = 123,
  force = FALSE,
  ...
)

\S4method{mp_cal_rarecurve}{MPSE}(
  .data,
  .abundance = NULL,
  action = "add",
  chunks = 400,
  seed = 123,
  force = FALSE,
  ...
)

\S4method{mp_cal_rarecurve}{tbl_mpse}(
  .data,
  .abundance = NULL,
  action = "add",
  chunks = 400,
  seed = 123,
  force = FALSE,
  ...
)

\S4method{mp_cal_rarecurve}{grouped_df_mpse}(
  .data,
  .abundance = NULL,
  action = "add",
  chunks = 400,
  seed = 123,
  force = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of otu abundance to be calculated.}

\item{action}{character it has three options, "add" joins the new
information to the input tbl (default), "only" return a non-redundant tibble 
with the just new information, ang 'get' return a 'rarecurve' object.}

\item{chunks}{numeric the split number of each sample to 
calculate alpha diversity, default is 400. eg. A sample has total 40000 reads,
if chunks is 400, it will be split to 100 sub-samples (100, 200, 300,..., 40000),
then alpha diversity index was calculated based on the sub-samples.}

\item{seed}{a random seed to make the result reproducible, default is 123.}

\item{force}{logical whether calculate rarecurve forcibly when the
'.abundance' is not be rarefied, default is FALSE}

\item{...}{additional parameters.}
}
\value{
update rarecurce calss
}
\description{
Calculating the different alpha diversities index with different depth
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%>\% 
mp_rrarefy() -> mpse
mpse
# larger 'chunks' means more robust, but it will become slower.
mpse \%<>\% mp_cal_rarecurve(.abundance=RareAbundance, chunks=100, action="add")
mpse
p1 <- mpse \%>\% 
      mp_plot_rarecurve(.rare=RareAbundanceRarecurve, .alpha="Observe")
p2 <- mpse \%>\%
      mp_plot_rarecurve(.rare=RareAbundanceRarecurve, .alpha=c("Observe", "ACE"))
}
\seealso{
[mp_plot_rarecurve()] and [mp_extract_rarecurve()]
}
\author{
Shuangbin Xu
}
