% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_diff_clade.R
\name{mp_diff_clade}
\alias{mp_diff_clade}
\alias{mp_diff_clade,MPSE-method}
\alias{mp_diff_clade,MPSE}
\alias{mp_diff_clade,tbl_mpse-method}
\alias{mp_diff_clade,tbl_mpse}
\alias{mp_diff_clade,grouped_df_mpse-method}
\alias{mp_diff_clade,grouped_df_mpse}
\title{Differential internal and tip nodes (clades) analysis for MPSE or tbl_mpse object}
\usage{
mp_diff_clade(
  .data,
  .abundance,
  .group,
  .sec.group = NULL,
  action = "add",
  force = FALSE,
  relative = TRUE,
  first.test.method = "kruskal.test",
  first.test.alpha = 0.05,
  p.adjust = "fdr",
  filter.p = "fdr",
  strict = TRUE,
  fc.method = "generalizedFC",
  second.test.method = "wilcox.test",
  second.test.alpha = 0.05,
  cl.min = 5,
  cl.test = TRUE,
  subcl.min = 3,
  subcl.test = TRUE,
  ml.method = "lda",
  normalization = 1e+06,
  ldascore = 2,
  bootnums = 30,
  sample.prop.boot = 0.7,
  ci = 0.95,
  seed = 123,
  type = "species",
  ...
)

\S4method{mp_diff_clade}{MPSE}(
  .data,
  .abundance,
  .group,
  .sec.group = NULL,
  action = "add",
  force = FALSE,
  relative = TRUE,
  first.test.method = "kruskal.test",
  first.test.alpha = 0.05,
  p.adjust = "fdr",
  filter.p = "fdr",
  strict = TRUE,
  fc.method = "generalizedFC",
  second.test.method = "wilcox.test",
  second.test.alpha = 0.05,
  cl.min = 5,
  cl.test = TRUE,
  subcl.min = 3,
  subcl.test = TRUE,
  ml.method = "lda",
  normalization = 1e+06,
  ldascore = 2,
  bootnums = 30,
  sample.prop.boot = 0.7,
  ci = 0.95,
  seed = 123,
  type = "species",
  ...
)

\S4method{mp_diff_clade}{tbl_mpse}(
  .data,
  .abundance,
  .group,
  .sec.group = NULL,
  action = "add",
  force = FALSE,
  relative = TRUE,
  first.test.method = "kruskal.test",
  first.test.alpha = 0.05,
  p.adjust = "fdr",
  filter.p = "fdr",
  strict = TRUE,
  fc.method = "generalizedFC",
  second.test.method = "wilcox.test",
  second.test.alpha = 0.05,
  cl.min = 5,
  cl.test = TRUE,
  subcl.min = 3,
  subcl.test = TRUE,
  ml.method = "lda",
  normalization = 1e+06,
  ldascore = 2,
  bootnums = 30,
  sample.prop.boot = 0.7,
  ci = 0.95,
  seed = 123,
  type = "species",
  ...
)

\S4method{mp_diff_clade}{grouped_df_mpse}(
  .data,
  .abundance,
  .group,
  .sec.group = NULL,
  action = "add",
  force = FALSE,
  relative = TRUE,
  first.test.method = "kruskal.test",
  first.test.alpha = 0.05,
  p.adjust = "fdr",
  filter.p = "fdr",
  strict = TRUE,
  fc.method = "generalizedFC",
  second.test.method = "wilcox.test",
  second.test.alpha = 0.05,
  cl.min = 5,
  cl.test = TRUE,
  subcl.min = 3,
  subcl.test = TRUE,
  ml.method = "lda",
  normalization = 1e+06,
  ldascore = 2,
  bootnums = 30,
  sample.prop.boot = 0.7,
  ci = 0.95,
  seed = 123,
  type = "species",
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated}

\item{.group}{the group name of the samples to be calculated.}

\item{.sec.group}{the second group name of the samples to be calculated.}

\item{action}{character, "add" joins the new information to the taxatree (if it exists) 
and otutree (if it exists) or \code{rowData} and return MPSE object,"only" return a 
non-redundant tibble with the result of different analysis. "get" return 'diffAnalysisClass' 
object.}

\item{force}{logical whether to calculate the relative abundance forcibly when the abundance
is not be rarefied, default is FALSE.}

\item{relative}{logical whether calculate the relative abundance, default is TRUE.}

\item{first.test.method}{the method for first test, option is "kruskal.test", "oneway.test", 
"lm", "glm", or "glm.nb", "kruskal_test", "oneway_test" of "coin" package. default is "kruskal.test".}

\item{first.test.alpha}{numeric the alpha value for the first test, default is 0.05.}

\item{p.adjust}{character the correction method, default is "fdr", see also p.adjust function
default is fdr.}

\item{filter.p}{character the method to filter pvalue, default is fdr, meanings the features 
that fdr <= .first.test.alpha will be kept, if it is set to pvalue, meanings the features that
pvalue <= .first.test.alpha will be kept.}

\item{strict}{logical whether to performed in one-against-one when .sec.group is provided, 
default is TRUE (strict).}

\item{fc.method}{character the method to check which group has more abundance for the 
significantly different features, default is "generalizedFC", options are \code{generalizedFC}, 
\code{compare_median}, \code{compare_mean}.}

\item{second.test.method}{the method for one-against-one (the second test), default is "wilcox.test" 
other option is one of 'wilcox_test' of 'coin'; 'glm'; 'glm.nb' of 'MASS'.}

\item{second.test.alpha}{numeric the alpha value for the second test, default is 0.05.}

\item{cl.min}{integer the minimum number of samples per group for performing test, default is 5.}

\item{cl.test}{logical whether to perform test (second test) between the groups (the number of sample
of the .group should be also larger that cl.min), default is TRUE.}

\item{subcl.min}{integer the minimum number of samples in each second groups for performing test, 
default is 3.}

\item{subcl.test}{logical whether to perform test for between the second groups (the .sec.group 
should be provided and the number sample of each .sec.group should be larger than subcl.min, and 
strict is TRUE), default is TRUE.}

\item{ml.method}{the method for calculating the effect size of features, option is 'lda' or 'rf'.
default is 'lda'.}

\item{normalization}{integer set a big number if to get more meaningful values for the LDA score, 
or you can set NULL for no normalization, default is 1000000.}

\item{ldascore}{numeric the threshold on the absolute value of the logarithmic LDA score, default is 2.}

\item{bootnums}{integer, set the number of bootstrap iteration for lda or rf, default is 30.}

\item{sample.prop.boot}{numeric range from 0 to 1, the proportion of samples for calculating the effect
size of features, default is 0.7.}

\item{ci}{numeric, the confidence interval of effect size (LDA or MDA), default is 0.95.}

\item{seed}{a random seed to make the analysis reproducible, default is 123.}

\item{type}{character type="species" meaning the abundance matrix is from the species abundance, other 
option is "others", default is "species".}

\item{...}{additional parameters}
}
\value{
update object according to the action argument.
}
\description{
Differential internal and tip nodes (clades) analysis for MPSE or tbl_mpse object
}
\examples{
\dontrun{
  suppressPackageStartupMessages(library(curatedMetagenomicData))
  xx <- curatedMetagenomicData('ZellerG_2014.relative_abundance', dryrun=F)
  xx[[1]] \%>\% as.mpse -> mpse
  mpse.agg.clade <- mpse \%>\%
    mp_aggregate_clade(
      .abundance = Abundance,
      force = TRUE,
      relative = FALSE,
      action = 'add' # other option is 'get' or 'only'.
    )
  mpse.agg.clade \%>\% mp_diff_clade(
      .abundance = Abundance,
      force = TRUE,
      relative = FALSE,
      .group = disease,
      fc.method = "compare_mean"
    ) \%>\%
  mp_extract_otutree() \%>\%
  dplyr::filter(!is.na(Sign_disease), keep.td = FALSE)
}
}
\author{
Shuangbin Xu
}
