% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_adonis_anosim.R
\name{mp_dmngroup}
\alias{mp_dmngroup}
\alias{mp_dmngroup,MPSE-method}
\alias{mp_dmngroup,MPSE}
\alias{mp_dmngroup,tbl_mpse-method}
\alias{mp_dmngroup,tbl_mpse}
\alias{mp_dmngroup,grouped_df_mpse-method}
\alias{mp_dmngroup,grouped_df_mpse}
\title{Dirichlet-Multinomial generative classifiers to MPSE or tbl_mpse}
\usage{
mp_dmngroup(.data, .abundance, .group, k = 1, action = "get", ...)

\S4method{mp_dmngroup}{MPSE}(.data, .abundance, .group, k = 1, action = "get", ...)

\S4method{mp_dmngroup}{tbl_mpse}(.data, .abundance, .group, k = 1, action = "get", ...)

\S4method{mp_dmngroup}{grouped_df_mpse}(.data, .abundance, .group, k = 1, action = "get", ...)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{The column name of OTU abundance column to be calculate.}

\item{.group}{the column name of group variable.}

\item{k}{the number of Dirichlet components to fit, default is 1.}

\item{action}{character it has three options, 'get' return a 'list' contained
DMN (default), "add" joins the new information to the input (can be extracted
with mp_extract_internal_attr(name='DMNGroup')), "only" return a non-redundant tibble
with the just new information a column contained 'DMNGroup'.}

\item{...}{additional parameters, see also the \code{\link[parallel]{mclapply}}
and \code{\link[DirichletMultinomial]{dmngroup}}.}
}
\value{
update object or others (refer to action argument)
}
\description{
Dirichlet-Multinomial generative classifiers to MPSE or tbl_mpse
}
\examples{
\dontrun{
data(mouse.time.mpse)
mouse.time.mpse \%>\% 
  mp_dmngroup(
    .abundance = Abundance,
    .group = time,
    k=seq_len(2),
    action = 'get'
  )
}
}
