% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_mantel.R
\name{mp_mantel}
\alias{mp_mantel}
\alias{mp_mantel,MPSE-method}
\alias{mp_mantel,MPSE}
\alias{mp_mantel,tbl_mpse-method}
\alias{mp_mantel,tbl_mpse}
\alias{mp_mantel,grouped_df_mpse-method}
\alias{mp_mantel,grouped_df_mpse}
\title{Mantel and Partial Mantel Tests for MPSE or tbl_mpse Object}
\usage{
mp_mantel(
  .data,
  .abundance,
  .y.env,
  .z.env = NULL,
  distmethod = "bray",
  distmethod.y = "euclidean",
  distmethod.z = "euclidean",
  method = "pearson",
  permutations = 999,
  action = "get",
  seed = 123,
  scale.y = FALSE,
  scale.z = FALSE,
  ...
)

\S4method{mp_mantel}{MPSE}(
  .data,
  .abundance,
  .y.env,
  .z.env = NULL,
  distmethod = "bray",
  distmethod.y = "euclidean",
  distmethod.z = "euclidean",
  method = "pearson",
  permutations = 999,
  action = "get",
  seed = 123,
  scale.y = FALSE,
  scale.z = FALSE,
  ...
)

\S4method{mp_mantel}{tbl_mpse}(
  .data,
  .abundance,
  .y.env,
  .z.env = NULL,
  distmethod = "bray",
  distmethod.y = "euclidean",
  distmethod.z = "euclidean",
  method = "pearson",
  permutations = 999,
  action = "get",
  seed = 123,
  scale.y = FALSE,
  scale.z = FALSE,
  ...
)

\S4method{mp_mantel}{grouped_df_mpse}(
  .data,
  .abundance,
  .y.env,
  .z.env = NULL,
  distmethod = "bray",
  distmethod.y = "euclidean",
  distmethod.z = "euclidean",
  method = "pearson",
  permutations = 999,
  action = "get",
  seed = 123,
  scale.y = FALSE,
  scale.z = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of otu abundance to be calculated}

\item{.y.env}{the column names of continuous environment factors to
perform Mantel statistic, it is required.}

\item{.z.env}{the column names of continuous environment factors to 
perform Partial Mantel statistic based on this, default is NULL.}

\item{distmethod}{character the method to calculate distance based on .abundance.}

\item{distmethod.y}{character the method to calculate distance based on .y.env.}

\item{distmethod.z}{character the method of calculated distance based on .z.env}

\item{method}{character Correlation method, options is "pearson", "spearman" or
"kendall"}

\item{permutations}{the number of permutations required, default is 999.}

\item{action}{character, "add" joins the mantel result to the internal attributes
of the object, "only" and "get" return 'mantel' or 'mantel.partial' (if .z.env is
provided) object.}

\item{seed}{a random seed to make the analysis reproducible, default is 123.}

\item{scale.y}{logical whether scale the environment matrix (.y.env) before 
the distance is calculated, default is FALSE}

\item{scale.z}{logical whether scale the environment matrix (.z.env) before
the distance is calculated, default is FALSE}

\item{...}{additional parameters, see also \code{\link[vegan]{mantel}}.}
}
\value{
update object or tibble according the 'action'
}
\description{
Mantel and Partial Mantel Tests for MPSE or tbl_mpse Object
}
\examples{
library(vegan)
data(varespec, varechem)
mpse <- MPSE(assays=list(Abundance=t(varespec)), colData=varechem)
mpse \%>\% mp_mantel(.abundance=Abundance, 
                   .y.env=colnames(varechem),
                   distmethod.y="euclidean",
                   scale.y = TRUE
                   )
}
\seealso{
\code{\link[vegan]{mantel}}
}
