% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grl_helpers.R
\name{coverageByTranscriptW}
\alias{coverageByTranscriptW}
\title{coverageByTranscript with weights}
\usage{
coverageByTranscriptW(
  x,
  transcripts,
  ignore.strand = FALSE,
  weight = 1L,
  seqinfo.x.is.correct = FALSE
)
}
\arguments{
\item{x}{reads (\code{\link{GRanges}}, \code{\link{GAlignments}})}

\item{transcripts}{\code{\link{GRangesList}}}

\item{ignore.strand}{a logical (default: FALSE)}

\item{weight}{a vector (default: 1L), if single number applies for all,
else it must be the string name of a defined meta column in "x",
that gives number of times a read was found.
GRanges("chr1", 1, "+", score = 5), would mean score column tells
that this alignment was found 5 times.}

\item{seqinfo.x.is.correct}{logical, default FALSE. If you know x, has
correct seqinfo, then you can save some computation time by setting this to
TRUE.}
}
\value{
Integer Rle of coverage, 1 per transcript
}
\description{
Extends the function with weights,
see \code{\link{coverageByTranscript}} for original function.
}
