% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORFs_helpers.R
\name{defineTrailer}
\alias{defineTrailer}
\title{Defines trailers for ORF.}
\usage{
defineTrailer(ORFranges, transcriptRanges, lengthOftrailer = 200)
}
\arguments{
\item{ORFranges}{GRanges object of your Open Reading Frame.}

\item{transcriptRanges}{GRanges object of transtript.}

\item{lengthOftrailer}{Numeric. Default is 10.}
}
\value{
A GRanges object of trailer.
}
\description{
Creates GRanges object as a trailer for ORFranges representing ORF,
maintaining restrictions of transcriptRanges. Assumes that ORFranges
is on the transcriptRanges, strands and seqlevels are in agreement.
When lengthOFtrailer is smaller than space left on the transcript than
all available space is returned as trailer.
}
\details{
It assumes that ORFranges and transcriptRanges are not
sorted when on minus strand. Should be like:
(200, 600)
(50, 100)
}
\examples{
ORFranges <- GRanges(seqnames = Rle(rep("1", 3)),
                     ranges = IRanges(start = c(1, 10, 20),
                                      end = c(5, 15, 25)),
                     strand = "+")
transcriptRanges <- GRanges(seqnames = Rle(rep("1", 5)),
                            ranges = IRanges(start = c(1, 10, 20, 30, 40),
                                             end = c(5, 15, 25, 35, 45)),
                     strand = "+")
defineTrailer(ORFranges, transcriptRanges)

}
\seealso{
Other ORFHelpers: 
\code{\link{longestORFs}()},
\code{\link{mapToGRanges}()},
\code{\link{orfID}()},
\code{\link{startCodons}()},
\code{\link{startSites}()},
\code{\link{stopCodons}()},
\code{\link{stopSites}()},
\code{\link{txNames}()},
\code{\link{uniqueGroups}()},
\code{\link{uniqueOrder}()}
}
\concept{ORFHelpers}
