% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_features.R
\name{distToTSS}
\alias{distToTSS}
\title{Get distances between ORF Start and TSS of its transcript}
\usage{
distToTSS(ORFs, tx)
}
\arguments{
\item{ORFs}{orfs as \code{\link{GRangesList}},
names of orfs must be txname_[rank]}

\item{tx}{transcripts as \code{\link{GRangesList}}.}
}
\value{
an integer vector, 1 means on TSS, 2 means second base of Tx.
}
\description{
Matching is done by transcript names.
This is applicable practically to any region in Transcript
If ORF is not within specified search space in tx, this function
will crash.
}
\examples{
grl <- GRangesList(tx1_1 = GRanges("1", IRanges(5, 10), "+"))
tx <- GRangesList(tx1 = GRanges("1", IRanges(2, 20), "+"))
distToTSS(grl, tx)

}
\references{
doi: 10.1074/jbc.R116.733899
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
