% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_positions.R
\name{downstreamOfPerGroup}
\alias{downstreamOfPerGroup}
\title{Get rest of objects downstream (exclusive)}
\usage{
downstreamOfPerGroup(tx, downstreamOf)
}
\arguments{
\item{tx}{a \code{\link{GRangesList}},
usually of Transcripts to be changed}

\item{downstreamOf}{a vector of integers, for each group in tx, where
is the new start point of first valid exon. Can also be a GRangesList,
then stopsites will be used.}
}
\value{
a GRangesList of downstream part
}
\description{
Per group get the part downstream of position.
downstreamOfPerGroup(tx, stopSites(cds, asGR = TRUE))
will return the 3' utrs per transcript as GRangesList,
usually used for interesting
parts of the transcripts.
}
\details{
If you want to include the points given in the region,
use downstreamFromPerGroup
}
\seealso{
Other GRanges: 
\code{\link{assignFirstExonsStartSite}()},
\code{\link{assignLastExonsStopSite}()},
\code{\link{downstreamFromPerGroup}()},
\code{\link{upstreamFromPerGroup}()},
\code{\link{upstreamOfPerGroup}()}
}
\concept{GRanges}
\keyword{internal}
