% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_helpers.R
\name{windowPerTranscript}
\alias{windowPerTranscript}
\title{Get a binned coverage window per transcript}
\usage{
windowPerTranscript(
  txdb,
  reads,
  splitIn3 = TRUE,
  windowSize = 100,
  fraction = "1",
  weight = "score",
  drop.zero.dt = FALSE,
  BPPARAM = bpparam()
)
}
\arguments{
\item{txdb}{a TxDb object or a path to gtf/gff/db file.}

\item{reads}{GRanges or GAlignment of reads}

\item{splitIn3}{a logical(TRUE), split window in 3 (leader, cds, trailer)}

\item{windowSize}{an integer (100), size of windows (columns). All genes with
region smaller than this size are filter out for metacoverage.}

\item{fraction}{a character (1), info on reads (which read length,
or which type (RNA seq)) (row names)}

\item{weight}{(default: 'score'), if defined a character name
of valid meta column in subject. GRanges("chr1", 1, "+", score = 5),
would mean score column tells that this alignment region was found 5 times.
Formats which loads a score column like this:
Bigwig, wig, ORFik ofst, collapsed bam, bedoc and .bedo.
As do CAGEr CAGE files and many other package formats.
You can also assign a score column manually.}

\item{drop.zero.dt}{logical FALSE, if TRUE and as.data.table is TRUE,
remove all 0 count positions.
This greatly speeds up and most importantly, greatly reduces memory usage.
Will not change any plots, unless 0 positions are used in some sense.
(mean, median, zscore coverage will only scale differently)}

\item{BPPARAM}{how many cores/threads to use? default: bpparam()}
}
\value{
a data.table with columns position, score
}
\description{
Per transcript (or other regions), bin them all to windowSize (default 100),
and make a data.table, rows are positions, useful for plotting with ORFik
and ggplot2.
}
\details{
NOTE: All ranges with smaller width than windowSize, will of course be
removed. What is the 100th position on a 1 width object ?
}
\keyword{internal}
