% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR.R
\name{STAR.install}
\alias{STAR.install}
\title{Download and prepare STAR}
\usage{
STAR.install(folder = "~/bin", version = "2.7.4a")
}
\arguments{
\item{folder}{path to folder for download, fille will be named
"STAR-version", where version is version wanted.}

\item{version}{default "2.7.4a"}
}
\value{
path to runnable STAR
}
\description{
Will not run "make", only use precompiled STAR file.\cr
Can only run on unix systems (Linux and Mac), and requires
minimum 30GB memory on genomes like human, rat, zebrafish etc.
}
\details{
ORFik for now only uses precompiled STAR binaries, so if you already have
a STAR version it is adviced to redownload the same version, since
STAR genome indices usually does not work between STAR versions.
}
\examples{
## Default folder install:
#STAR.install()
## Manual set folder:
folder <- "/I/WANT/IT/HERE"
#STAR.install(folder, version = "2.7.4a")

}
\references{
https://www.ncbi.nlm.nih.gov/pubmed/23104886
}
\seealso{
Other STAR: 
\code{\link{STAR.align.folder}()},
\code{\link{STAR.align.single}()},
\code{\link{STAR.allsteps.multiQC}()},
\code{\link{STAR.index}()},
\code{\link{STAR.multiQC}()},
\code{\link{STAR.remove.crashed.genome}()},
\code{\link{getGenomeAndAnnotation}()},
\code{\link{install.fastp}()}
}
\concept{STAR}
