% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_footprints_helpers.R
\name{isPeriodic}
\alias{isPeriodic}
\title{Find if there is a periodicity of 3 in the vector}
\usage{
isPeriodic(x, info = NULL, verbose = FALSE, strict.fft = TRUE)
}
\arguments{
\item{x}{(numeric) Vector of values to detect periodicity of 3 like in
RiboSeq data.}

\item{info}{specify read length if wanted for verbose output.}

\item{verbose}{logical, default FALSE.
Report details of analysis/periodogram. Good if you are not sure
if the analysis was correct.}

\item{strict.fft}{logical, TRUE. Use a FFT without noise filter.
This means keep only reads lengths that are "periodic for the human eye".
If you want more coverage, set to FALSE, to also get read lengths
that are "messy", but the noise filter detects the periodicity of 3.
This should only be done when you do not need high quality
periodic reads! Example would be differential translation analysis by
counts over each ORF.}
}
\value{
a logical, if it is periodic.
}
\description{
It uses Fourier transform + periodogram for finding periodic
vectors on the transcript
normalized counts over all CDS regions from position 0 (TIS) to 149
(or other max position if increased by the user.\cr
Checks if there is a periodicity and if the periodicity is 3,
more precisely between 2.9 and 3.1.\cr
}
\details{
Input data:\cr
Transcript normalized means per CDS TIS region, count reads per position,
divide that number per position by the total of that transcript, then sum
up these numbers per position for all transcripts.\cr
Detection method:\cr
The maximum dominant Fourier frequencies is found by finding which
period has the highest spectrum density (using a 10% cosine taper).
}
\keyword{internal}
