% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastq_helpers.R
\name{mergeFastq}
\alias{mergeFastq}
\title{Merge groups of Fastq /Fasta files}
\usage{
mergeFastq(in_files, out_files, BPPARAM = bpparam())
}
\arguments{
\item{in_files}{\code{character} specify the full path to the individual fastq.gz files.
Seperated by space per file in group: For 2 output files from 4 input files:
in_files <- c("file1.fastq file2.fastq". "file3.fastq file4.fastq")}

\item{out_files}{\code{character} specify the path to the FASTQ directory
For 2 output files: out_files <- c("/merged/file1&2.fastq", "/merged/file3&4.fastq")}

\item{BPPARAM}{how many cores/threads to use? default: bpparam().
To see number of threads used, do \code{bpparam()$workers}}
}
\value{
invisible(NULL).
}
\description{
Will use multithreading to speed up process.
Only works for Unix OS (Linux and Mac)
}
\examples{
fastq.folder <- tempdir() # <- Your fastq files
infiles <- dir(fastq.folder, "*.fastq", full.names = TRUE)
\dontrun{
# Seperate files into groups (here it is 4 output files from 12 input files)
in_files <- c(paste0(grep(infiles, pattern = paste0("ribopool-",
               seq(11, 14), collapse = "|"), value = TRUE), collapse = " "),
              paste0(grep(infiles, pattern = paste0("ribopool-",
               seq(18, 19), collapse = "|"), value = TRUE), collapse = " "),
              paste0(grep(infiles, pattern = paste0("C11-",
               seq(11, 14), collapse = "|"), value = TRUE), collapse = " "),
              paste0(grep(infiles, pattern = paste0("C11-",
               seq(18, 19), collapse = "|"), value = TRUE), collapse = " "))

out_files <- paste0(c("SSU_ribopool", "LSU_ribopool", "SSU_WT", "LSU_WT"), ".fastq.gz")
merged.fastq.folder <- file.path(fastq.folder, "merged/")
out_files <- file.path(merged.fastq.folder, out_files)

mergeFastq(in_files, out_files)
}
}
