% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grl_region.R
\name{pseudoIntronsPerGroup}
\alias{pseudoIntronsPerGroup}
\title{Get pseudo introns per Group}
\usage{
pseudoIntronsPerGroup(grl, width = 100)
}
\arguments{
\item{grl}{a GrangesList of length 1}

\item{width}{numeric, default 100. The size of pseudo flanks.}
}
\value{
a GRangesList
}
\description{
If an intron is of length < 'width' * 2, it will not be split into pseudo.
}
\examples{
tx <- GRangesList(GRanges("1", IRanges(c(1, 150, 1e5, 1e6)), "+"))
pseudoIntronsPerGroup(tx) # See intron 1 is not split
tx_2 <- rep(GRangesList(GRanges("1", IRanges(c(1, 150, 1e5, 1e6)), "+")), 2)
pseudoIntronsPerGroup(tx_2)
pseudoIntronsPerGroup(tx_2, 1e6)
}
