% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_helpers.R
\name{readLengthTable}
\alias{readLengthTable}
\title{Make table of readlengths}
\usage{
readLengthTable(
  df,
  output.dir = NULL,
  type = "ofst",
  force = TRUE,
  library.names = bamVarName(df),
  BPPARAM = bpparam()
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{output.dir}{NULL or character path, default: NULL, plot not saved to disc.
If defined saves plot to that directory with the name "./readLengths.csv".}

\item{type}{character, default: "ofst". Type of library:
either "default", usually bam format (the one you gave to experiment),
"pshifted" pshifted reads, "ofst", "bed", "bedo" optimized bed, or "wig"}

\item{force}{logical, default TRUE If TRUE, reload library files even if
matching named variables are found in environment used by experiment
 (see \code{\link{envExp}}) A simple way to make
sure correct libraries are always loaded. FALSE is faster if data
is loaded correctly already.}

\item{library.names}{character vector, names of libraries, default:
name_decider(df, naming)}

\item{BPPARAM}{a core param, default: single thread: \code{BiocParallel::SerialParam()}.
Set to \code{BiocParallel::bpparam()} to use multicore. Be aware, this uses a lot of
extra ram (40GB+) for larger human samples!}
}
\value{
a data.table object of the the read length data with columns:
\code{c("sample", "sample_id", "read length", "counts",
 "counts_per_sample", "perc_of_counts_per_sample")}
}
\description{
Summarizing all libraries in experiment,
make a table of proportion of read lengths.
}
\keyword{internal}
