% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_footprints.R
\name{shiftFootprints}
\alias{shiftFootprints}
\title{Shift footprints by selected offsets}
\usage{
shiftFootprints(footprints, shifts, sort = TRUE)
}
\arguments{
\item{footprints}{\code{\link{GAlignments}} object of RiboSeq reads -
footprints, can also be path to the .bam /.ofst file. If GAlignment object
has a meta column called "score", this will be used as replicate numbering
for that read. So be careful if you have custom files with score columns,
with another meaning.}

\item{shifts}{a data.frame / data.table with minimum 2 columns,
fraction (selected read lengths) and offsets_start (relative position in nt).
Output from \code{\link{detectRibosomeShifts}}.\cr
Run \code{ORFik::shifts_load(df)[[1]]} for an example of input.}

\item{sort}{logical, default TRUE. If False will keep original order of
reads, and not sort output reads in increasing genomic location per
chromosome and strand.}
}
\value{
A \code{\link{GRanges}} object of shifted footprints, sorted and
resized to 1bp of p-site,
with metacolumn "size" indicating footprint size before shifting and
resizing, sorted in increasing order.
}
\description{
Function shifts footprints (GRanges) using specified offsets for every of
the specified lengths. Reads that do not conform to the specified lengths
are filtered out and rejected. Reads are resized to single base in 5' end
fashion, treated as p site.
This function takes account for junctions and soft clips in cigars of the
reads. Length of the footprint is saved in size' parameter of GRanges output.
Footprints are also sorted according to their genomic position,
ready to be saved as a ofst, covRle, bed or wig file.
}
\details{
The two columns in the shift data.frame/data.table argument are:\cr
- fraction Numeric vector of lengths of footprints you select
for shifting.\cr
- offsets_start Numeric vector of shifts for corresponding
selected_lengths. eg. c(-10, -10) with selected_lengths of c(31, 32) means
length of 31 will be shifted left by 10. Footprints of length 32 will be
shifted right by 10.

NOTE: It will remove softclips from valid width, the CIGAR 3S30M is qwidth
33, but will remove 3S so final read width is 30 in ORFik.
}
\examples{
## Basic run
# Transcriptome annotation ->
gtf_file <- system.file("extdata/references/danio_rerio", "annotations.gtf", package = "ORFik")
# Ribo seq data ->
riboSeq_file <- system.file("extdata/Danio_rerio_sample", "ribo-seq.bam", package = "ORFik")
\dontrun{
footprints <- readBam(riboSeq_file)

# detect the shifts automagically
shifts <- detectRibosomeShifts(footprints, gtf_file)
# shift the RiboSeq footprints
shiftedReads <- shiftFootprints(footprints, shifts)
}
}
\references{
https://bmcgenomics.biomedcentral.com/articles/10.1186/s12864-018-4912-6
}
\seealso{
Other pshifting: 
\code{\link{changePointAnalysis}()},
\code{\link{detectRibosomeShifts}()},
\code{\link{shiftFootprintsByExperiment}()},
\code{\link{shiftPlots}()},
\code{\link{shifts_load}()},
\code{\link{shifts_save}()}
}
\concept{pshifting}
