% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_helpers.R
\name{splitIn3Tx}
\alias{splitIn3Tx}
\title{Create binned coverage of transcripts, split into the 3 parts.}
\usage{
splitIn3Tx(
  leaders,
  cds,
  trailers,
  reads,
  windowSize = 100,
  fraction = "1",
  weight = "score",
  is.sorted = FALSE,
  drop.zero.dt = FALSE,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{leaders}{a \code{\link{GRangesList}} of leaders (5' UTRs)}

\item{cds}{a \code{\link{GRangesList}} of coding sequences}

\item{trailers}{a \code{\link{GRangesList}} of trailers (3' UTRs)}

\item{reads}{GRanges or GAlignment of reads}

\item{windowSize}{an integer (100), size of windows (columns). All genes with
region smaller than this size are filter out for metacoverage.}

\item{fraction}{a character (1), info on reads (which read length,
or which type (RNA seq)) (row names)}

\item{weight}{(default: 'score'), if defined a character name
of valid meta column in subject. GRanges("chr1", 1, "+", score = 5),
would mean score column tells that this alignment region was found 5 times.
Formats which loads a score column like this:
Bigwig, wig, ORFik ofst, collapsed bam, bedoc and .bedo.
As do CAGEr CAGE files and many other package formats.
You can also assign a score column manually.}

\item{is.sorted}{logical (FALSE), is grl sorted. That is + strand groups in
increasing ranges (1,2,3), and - strand groups in decreasing ranges (3,2,1)}

\item{drop.zero.dt}{logical FALSE, if TRUE and as.data.table is TRUE,
remove all 0 count positions.
This greatly speeds up and most importantly, greatly reduces memory usage.
Will not change any plots, unless 0 positions are used in some sense.
(mean, median, zscore coverage will only scale differently)}

\item{BPPARAM}{how many cores/threads to use? default: bpparam()}
}
\value{
a data.table with columns position, score
}
\description{
The 3 parts  of transcripts are the leaders, the cds' and trailers.
Per transcript part, bin them all to windowSize (default 100),
and make a data.table, rows are positions, useful for plotting with ORFik
and ggplot2.
}
\keyword{internal}
