% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR_multiQC.R
\name{trimming.table}
\alias{trimming.table}
\title{Create trimming table}
\usage{
trimming.table(
  trim_folder,
  raw_libraries = dir(trim_folder, "\\\\.json$", full.names = TRUE),
  include_adapter = FALSE
)
}
\arguments{
\item{trim_folder}{folder of trimmed files, only reads
fastp .json files. Can be NULL if raw_libraries is defined}

\item{raw_libraries}{character, default:
\code{dir(trim_folder, "\\.json", full.names = TRUE)},
file paths of all json file paths.}

\item{include_adapter}{logical, default FALSE. If TRUE, will add
an extra column: adapter, with adapter found. If not found, it will specify:
 "passed".}
}
\value{
a data.table with 6 columns, raw_library (names of library),
 raw_reads (numeric, number of raw reads),
 trim_reads (numeric, number of trimmed reads),
 % trimmed (numeric, percentage of trimmed reads),
 raw_mean_length (numeric, raw mean read length),
 trim_mean_length (numeric, trim mean read length).
 Optional columns:
 adapter (character, adapter, if not found "passed")
}
\description{
From fastp runs in ORFik alignment process
}
\examples{
# Location of fastp trimmed .json files
trimmed_file <- system.file("extdata/test_processing/trim",
 "output_template.json", package = "ORFik")
trimmed_folder <- dirname(trimmed_file)
trimming.table(trimmed_folder)
trimming.table(NULL, trimmed_file)
trimming.table(NULL, trimmed_file, include_adapter = TRUE)
}
